<?php

/**
 * Plugin Name: WP Core Web Vitals
 * Description: Core Web Vitals Plugin - www.corewebvitals.io
 * Version: 7.5.11
 * Author: Arjen
 *
 *  @todo - add option to 'safe load' deferred javascript
 *  @todo - add option to bypass the preload scanner for js
 */


// zip -vr wp-core-web-vitals.zip ./wp-core-web-vitals

namespace WPCWV; 


// error reporting
error_reporting(0);



if(isset($_COOKIE['cwv_dbg'])) {
    error_reporting(E_ALL);
    ini_set('display_errors', '1');
}


// check if we need to bypass the plugin for this request
if (!isset($_COOKIE['cwv_no_plugin_for_you']) && !isset($_GET['fl_builder'])) {

    // define constants
    define('WP_CWV_PLUGIN_PATH', plugin_dir_path(__FILE__));
    define('WP_CWV_PLUGIN_DIR', plugin_dir_url(__FILE__));

    // now we can load the autoloader
    require_once(WP_CWV_PLUGIN_PATH . 'lib/autoload.php');

    // more constants
    define('WP_CWV_SITE_URL', get_site_url());
    define('WP_CWV_VERSION', '7.5.11');
    define('WP_CWV_DEBUG', (isset($_COOKIE['dbg'])) ? true : false);
    define('WP_CWV_MSG_DELAY', 2592000); /* 30 days */

    // licence key, not used at the moment but we might want to keep this to prevent abuse in the future
    define('WP_CWV_LICENCE_KEY', cwv_options::get('wp_cwv_key'));

    // try the cache
    cwv_cache::tryCache();

    add_action('init', function () {

        // no cache, lets' start the optimization
        $cwv = new CWV();

        // installation and updates
        cwv_admin_install::init();

        // settings page + menu options, self contained
        cwv_admin_settings::init();


        // preloads and admin hooks
        cwv_preloads::init();

        // debugging hooks
        debug::init();

        // script rules, admin stuff
        cwv_script_rules::init();

        // cache management, admin stuff
        cwv_cache::init();

        // advanced cache management, admin stuff
        cwv_advanced_cache::init();

        // notices
        cwv_notice::init();
    });
}
