const cwv_prefetch = {

    _list: new Set(),
    _block: false,
    _timer: null,

    init: function () {
        const isSupported = document.createElement('link').relList.supports('prefetch')

        if (!isSupported) {
            return
        }

        const eventListenersOptions = {
            capture: true,
            passive: true,
        }

        document.addEventListener('touchstart', cwv_prefetch.listenermobile, eventListenersOptions)
        document.addEventListener('mouseover', cwv_prefetch.listener, eventListenersOptions)
    },
    listener: function (event) {
        /* We might have input, prio to that!*/
        setTimeout(function () {
            if (!('closest' in event.target)) {
                return
            }

            const anchorElement = event.target.closest('a')
            if (!cwv_prefetch.isPreloadable(anchorElement)) {
                return
            }


            anchorElement.addEventListener('mouseout', cwv_prefetch.mouseoutListener, { passive: true })

            self._timer = setTimeout(() => {
                cwv_prefetch.preload(anchorElement.href);
                self._timer = null;
            }, 200)

            console.log('timer', self._timer);


        }, 0);
    },
    mouseoutListener: function (event) {
        if (event.relatedTarget && event.target.closest('a') == event.relatedTarget.closest('a')) {
            return
        }

        if (self._timer) {
            clearTimeout(self._timer)
            self._timer = undefined
        }
    },


    listenermobile: function (event) {
        /* We might have input, prio to that!*/
        setTimeout(function () {
            if (!('closest' in event.target)) {
                return
            }

            const anchorElement = event.target.closest('a')
            if (!cwv_prefetch.isPreloadable(anchorElement)) {
                return
            }

            cwv_prefetch.preload(anchorElement.href);
        }, 0);
    },
    isPreloadable: function (anchorElement) {
        if (!anchorElement || !anchorElement.href) {
            return false;
        }

        if (anchorElement.search || anchorElement.hash) {
            return false;
        }

        if (anchorElement.origin != location.origin) {
            return false;
        }

        if (!['http:', 'https:'].includes(anchorElement.protocol)) {
            return false;
        }

        return true
    },

    preload: function (url) {


        if (cwv_prefetch._list.has(url)) {
            console.log('already in list', url);
            return false;
        }

        if (self._block === true) {
            return false;
        }

        self._block = true;

        const el = document.createElement('link')
        el.rel = 'prefetch'
        el.href = url

        el.fetchPriority = 'high'
        el.as = 'document'

        el.onload = () => {
            el.onload = null
            self._block = false;
        }
        el.onerror = () => {
            el.onerror = null
            self._block = false;
        }
        console.log('prefetching', url);

        document.head.appendChild(el)
        cwv_prefetch._list.add(url)
    }
}




cwv_prefetch.init()






