var CWV_optimize = {
  /* readystate */
  _CWV_rs: "loading",
  /* listeners */
  _CWV_ls: [],
  /* events to catch */
  _CWV_ce: [
    "pageshow",
    "DOMContentLoaded",
    "readystatechange",
    "load",
  ],
  /* console message */
  _CWV_cm: " Core Web Vitals optimizer for Scripts",

  main: function () {
    console.log('Starting'+ CWV_optimize._CWV_cm);
    
    /* copy eventlistner */
    EventTarget.prototype.CWVaddEventListener =
      EventTarget.prototype.addEventListener;

    /* catch Readystate on document */
    CWV_optimize.CRS(document);

    /*  catch Eventlistern on document / window */
    CWV_optimize.CEL(document); 
    CWV_optimize.CEL(window);
  },

  complete: function () {
    /* reset old event listners */
    EventTarget.prototype.addEventListener =
      EventTarget.prototype.CWVaddEventListener;

    /*  execute event listners that were catched and finish up */
    /*console.log(['These are the events I have catched', CWV_optimize._CWV_ls]);*/
    for (var i in CWV_optimize._CWV_ls) {
      try {
        CWV_optimize._CWV_ls[i].listener();
      } catch (error) {}
    }
    CWV_optimize._CWV_rs = "complete";
    console.log('Completing'+ CWV_optimize._CWV_cm);

  },
  /* catch ready state */
  CRS: function (target) {
    Object.defineProperty(target, "readyState", {
      get: function (a) {
        return CWV_optimize._CWV_rs;
      },
      set: function (value) {
        /*console.log('set readystate', value);*/
        _onreadystatechange = value;
      },
      configurable: true 
    });
  },

  /* catch event listeners */
  CEL: function (target) {
    Object.defineProperty(target, "addEventListener", {
      value: function (xxtype, listener) {
        if (CWV_optimize._CWV_ce.indexOf(xxtype) != -1) {
          /*console.log(['catch',xxtype, listener]);*/
          CWV_optimize._CWV_ls.push({
            target: target,
            type: xxtype,
            listener: listener,
          });
        } else {
          /*console.log(['pass',xxtype, listener]);*/
          target.CWVaddEventListener(xxtype, listener);
        }
      },
    });
  },
};

CWV_optimize.main();
