<?php


namespace WPCWV;

if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}

class CWV
{

	public function __construct()
	{

		add_action('template_redirect', [$this, 'maybe_start'], 1);
	}


	public function maybe_start()
	{

		if (cwv_options::get('wp_cwv_late_cache')) {
			cwv_cache::tryCache('late');
		}

		// do not bother with some pages
		if (
			get_the_ID() > 0
			&& $_SERVER['REQUEST_METHOD'] == 'GET'
			&& (cwv_options::get('wp_cwv_page_cache_urlparam') == 1 || sizeof((array)$_GET) == 0)
			&& @sizeof((array)$_SERVER['argv']) == 0
		) {
			$this->start();
		}
	}

	public function start()
	{

		// disable emoji
		remove_action('wp_head', 'print_emoji_detection_script', 7);
		remove_action('admin_print_scripts', 'print_emoji_detection_script');
		remove_filter('the_content_feed', 'wp_staticize_emoji');
		remove_filter('comment_text_rss', 'wp_staticize_emoji');
		remove_action('wp_print_styles', 'print_emoji_styles');
		remove_action('admin_print_styles', 'print_emoji_styles');
		remove_filter('wp_mail', 'wp_staticize_emoji_for_email');

		// remove meta generator tag
		add_filter('the_generator', function () {
			return '';
		});


		add_action('template_redirect', [$this, 'ob_start']);
	}

	public function ob_start()
	{
		ob_start([$this, "ob_lazy_load_callback"]);
	}


	public function ob_lazy_load_callback($html)
	{
		// If I wanted to test some html I would use this line.
		// $html = file_get_contents(__DIR__ . '/html.txt');

		// bypass page?
		$urlPartsIgnored = cwv_options::get('wp_ignore_url_parts');
		$mIgnored = cwvh::ignored($html, $urlPartsIgnored);
		if ($mIgnored) {
			return $html . '<!-- ignored (' . $mIgnored . ') -->';
		}


		if (!current_user_can('administrator')) {

			debug::debug((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]", 1);

			$oCache = new CWVCache();
			$oFont = new FontStrategy();
			$oStyle = new StyleRewriteStrategy();
			$oScript = new ScriptDeferStrategy();
			$oExtraStyle = new StyleAddDOMStrategy();
			$oResourceHints = new ResourceHintsStrategy();
			$oImg = new ImgStrategy();
			$oIframe = new IframeStrategy();
			$oHtml = new HtmlStrategy();


			## Rewrite
			$html = $oFont->rewriteOutput($html);
			$html = $oResourceHints->rewriteOutput($html);
			$html = $oScript->rewriteOutput($html);
			$html = $oIframe->rewriteOutput($html);
			$html = $oStyle->rewriteOutput($html);
			$html = $oExtraStyle->rewriteOutput($html);
			$html = $oImg->rewriteOutput($html);
			$html = $oResourceHints->addLatePreloads($html);
			$html = $oHtml->rewriteOutput($html);


			$html = TagStorage::toHtml($html);

			/* maybe send a preload link for css and / or lcp */
			$linkheader = TagStorage::getLinkPreload();
			if ($linkheader != '') {
				header("Link: $linkheader", false);
			}

			// write the cache file
			$oCache->cache($html, $linkheader);
		} else {

			header('X-Accel-Buffering: no');
		}


		## Return html
		$line = '';
		foreach (debug::getDebugData() as $aDebug) {
			$line .= "<!-- " . str_repeat('------', ($aDebug['depth'] - 1)) . ' ' . $aDebug['str'] . " --> \n";
		}
		return $line . $html;
	}
}
