<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}

class ScriptDeferStrategy implements StrategyInterface
{

	private $inject = '';
	private $aScriptRules;

	public function rewriteOutput($html)
	{
		debug::debug('ENTER SCRIPTS ', 1);

		// first remove all condional tags from the html since this is not 1995 anymore!
		$html = preg_replace('/<!--\[if.*?\]>.*?\[endif\]-->/ms', '', $html);

		//$cwv_defer_scripts_lower_regex = cwv_options::get('cwv_defer_scripts_lower_regex');

		$cwv_footer_scripts = cwv_options::get('cwv_footer_scripts');
		$cwv_defer_scripts = cwv_options::get('cwv_defer_scripts');
		$cwv_optimize_script_events = cwv_options::get('cwv_optimize_script_events');

		if ($cwv_defer_scripts || $cwv_footer_scripts) {

			// find all rules
			$this->aScriptRules = ScriptRulesDB::findAll();

			// add CWV Loader to page
			debug::debug('Adding CWV Loader', 2);

			if($cwv_optimize_script_events){
				$script_content = file_get_contents(WP_CWV_PLUGIN_PATH .'public/js/cwv_loader.min.js'); 
				$html = preg_replace('/<\s*head\s*>/', '<head><script data-no-optimize="true">'.$script_content.'</script>', $html);
				$html = str_replace('</body', '<script>CWV_optimize.complete();</script></body', $html);
			}


			preg_match_all('#<script([^>]*)>(.*)</script>#isU', $html, $matches, PREG_SET_ORDER);
			foreach ($matches as $match) {
				$attrs = HtmlHelper::parseAttr($match[1]);
				$orig_script_html = $match[0];
				$new_script_html = $match[0];
				$script_contents = $match[2];
				$script_src = (array_key_exists('src', $attrs)) ? $attrs['src'] : false;
				$script_id = (array_key_exists('id', $attrs)) ? $attrs['id'] : false;
				
				$skip =false;

				// only loop javascript, ignore type="module" and type="application/ld+json" etc
				if (@$attrs['type'] == 'text/javascript' || @$attrs['type'] == '' || !array_key_exists('type', $attrs)) {
					debug::debug('Found script with id ' . $script_id, 2);
					$matchscript = false;
					
					if (isset($attrs['data-no-optimize'])|| @$attrs['data-cfasync'] == 'false' || stristr($orig_script_html, 'data-pagespeed-no-defer')) {
						$skip = true;
						debug::debug('Skipping because of data-no-optimize or cfasyn or data-pagespeed-no-defer' , 3);
						debug::debug($orig_script_html, 3);
					} else if ($script_contents && $script_src) {
						$skip = true;
						debug::debug('Skipping beause of content and src' . $script_src, 3);

						// not touching this crap ... do nothing!
					} else if ($script_contents) {
						debug::debug('Encoding to inline base64', 3);

						// inline script
						$matchscript = $script_contents;

						// new script src
						$clean_contents = preg_replace( '#<!--.*-->#sU', '', $script_contents );
						$script_src = 'data:text/javascript;base64,' . base64_encode($clean_contents);

						// rewrite script
						$new_script_html = str_replace('<script', '<script src="' . $script_src . '"', $new_script_html);
						$new_script_html = str_replace($script_contents, '', $new_script_html);
					} else if ($script_src) {
						debug::debug('Found src ' . $script_src, 3);
						// external script
						$matchscript = $script_src;
					}

					// check if there is a rule for this script
					$rule = $this->hasScriptRule($matchscript);

					if($skip === true){
						debug::debug('Skipping because of $skip', 4);

					} else if ($rule) {
						debug::debug('Following rule', 4);

						// there is a rule, let's follow it
						$new_script_html = $this->handleScriptRule($script_src, $rule, $orig_script_html);
					} else {


						// defer the script
						if ($cwv_defer_scripts) {
							$new_script_html = str_replace('<script ', '<script defer ', $new_script_html);
							//remove async
							$new_script_html = str_replace(' async ', ' ', $new_script_html);
							debug::debug('Defer the script', 4);
						}

						// maybe move the script to the footer
						if ($cwv_footer_scripts) {
							debug::debug('Move to footer', 5);

							$html = str_replace($orig_script_html, '', $html);
							$html = str_replace('</body', $orig_script_html . "\n" . '</body', $html);
						}
					}

					// finally replace the script!
					$html = str_replace($orig_script_html, $new_script_html, $html);
				}
			}


			if ($this->inject) {
				$loadscript = '<script>var cwv_loadscript = function(src){var _cwv_script = document.createElement("script");_cwv_script.src = src;_cwv_script.async = true;document.body.append(_cwv_script);};</script>';
				$lazyscript = '<script>var _cwv_done = [];var cwv_interactioncript = function(src) {["scroll", "touchend", "mouseover"].forEach(function(event){window.addEventListener(event, function() {_cwv_interactioncript(src, event);}, {passive: true,	once: true});});};var _cwv_interactioncript = function(src, evt) {if (_cwv_done.indexOf(src) == -1) {_cwv_done.push(src);cwv_loadscript(src);}}</script>';
				$html = str_replace('</body', $loadscript.$lazyscript . "\n<script>" . $this->inject . "</script>\n" . '</body', $html);
			}
		}
		return $html;
	}

	private function hasScriptRule($match)
	{
		foreach ($this->aScriptRules as $r) {
			if (stristr($match, $r->scriptregex)) {
				return $r;
			}
		}
		return false;
	}

	private function handleScriptRule($script_src, $rule, $orig_script_html)
	{
		if ($rule->scripttrigger == 'hover') {
			debug::debug('Inject on hover on ' . $rule->scriptselector, 5);

			$this->inject .= 'document.querySelector("' . $rule->scriptselector . '").addEventListener("mouseover",function(){cwv_loadscript("' . $script_src . '")},{ once: true });';
			return '';
		}

		if ($rule->scripttrigger == 'intersectionobserver') {
			debug::debug('Inject on intersection on ' . $rule->scriptselector, 5);

			$rnd = md5(microtime());
			$this->inject .= '
					const cwv_els' . $rnd . ' = document.querySelectorAll("' . $rule->scriptselector . '");
					observer = new IntersectionObserver(entries => {
					  entries.forEach(entry => {
					    if (entry.intersectionRatio > 0) {
					    	cwv_loadscript("' . $script_src . '");
					      observer.unobserve(entry.target);
					    } 
					  });
					});

					cwv_els' . $rnd . '.forEach(image => {
  						observer.observe(image);
					});
			';
			return '';
		}

		// load during idle time
		if ($rule->scripttrigger == 'idle') {
			debug::debug('Inject on requestIdleCallback ', 5);

			// update this to requestIdleCallback
			$this->inject .= 'window.addEventListener("load",function(){setTimeout(function(){cwv_loadscript("' . $script_src . '")},500); });';
			return '';
		}

		if ($rule->scripttrigger == 'interaction') {
			debug::debug('Inject on body interaction ', 5);

			$this->inject .= 'cwv_interactioncript("' . $script_src . '");';
			return '';
		}

		// remove this script
		if ($rule->scripttrigger == 'remove') {
			debug::debug('Remove this script', 5);
			return '';
		}

		// script should be render blocking
		if ($rule->scripttrigger == 'block') {
			debug::debug('Add as render blocking script', 5);
			return '<script src="' . $script_src . '" fetchpriority="high"></script>';
		}

		// script should be async
		if ($rule->scripttrigger == 'async') {
			debug::debug('Add as asynced script', 5);
			return '<script async src="' . $script_src . '" fetchpriority="high"></script>';
		}

		// script should be deferred
		if ($rule->scripttrigger == 'defer') {
			debug::debug('Add as deferred script', 5);
			return '<script defer src="' . $script_src . '"></script>';
		}

		// script should not be touched
		if ($rule->scripttrigger == 'ignore') {
			debug::debug('Skip optimisation', 5);

			return $orig_script_html;
		}
	}
}
