<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}
class ImgStrategy implements StrategyInterface
{

	// lcp image src
	private $lcp_img_src = false;
	private $injectJS = false;

	public function rewriteOutput($html)
	{
		debug::debug('ENTER IMAGES', 1);


		// variables
		$cwv_lazy_load_bg_images = cwv_options::get('cwv_lazy_load_bg_images');
		$cwv_lazy_load_images = cwv_options::get('cwv_lazy_load_images');
		$cwv_async_render_images = cwv_options::get('cwv_async_render_images');
		$cwv_img_width_height = cwv_options::get('cwv_img_width_height');
		$cwv_lcp_selector = cwv_options::get('cwv_lcp_selector');

		// rewrite html
		$html = $this->findAndPreloadLCPImage($html, $cwv_lcp_selector);
		$html = $this->setLazyLoading($html, $cwv_lazy_load_images,  $cwv_async_render_images, $cwv_img_width_height);
		$html = $this->lazyLoadBGImg($html, $cwv_lazy_load_bg_images);

		return $html;
	}

	


	/**
	 * add js lazy script
	 * @param $html
	 * @param $cwv_lazy_load_images_js
	 * @return string $html
	 */
	private function lazyLoadBGImg($html, $cwv_lazy_load_bg_images)
	{
		if (isset($cwv_lazy_load_bg_images) && $cwv_lazy_load_bg_images == 1) {
			debug::debug('Adding lazy load BG img CSS and script!', 2);
			$style = '<style id="lazybg">*{background-image:none!important;}</style>';
			$script = "<script>window.addEventListener('DOMContentLoaded', function() {document.getElementById('lazybg').remove();});</script>";
			$html = str_replace('</head>', $style . $script . '</head>', $html);
		}

		return $html;
	}



	private function preloadLCPImage($element, $html)
	{


		$preload_links = '';
		$aSourcesToPreload = [];
		$max = [-1, 1000000];
		$min = [-1, 1000000];

		// maybe it is in a picture element, parent elements should be source elements, lets loop them
		$parent = $element->parentNode;


		foreach ($parent->getElementsByTagName('source') as $sourcenode) {
			// get attributes from source element
			$media = ($sourcenode->getAttribute('media')) ? $sourcenode->getAttribute('media')  : '';
			$type = ($sourcenode->getAttribute('type')) ? 'type="' . $sourcenode->getAttribute('type') . '"' : '';
			$srcset  = ($sourcenode->getAttribute('srcset')) ? 'imagesrcset="' . $sourcenode->getAttribute('srcset') . '"' : false;


			// check for crappy max|min-width pattern
			$bmax = preg_match('/max-width\s*?:\s*?([0-9]+)([a-zA-Z]+)/i', $media, $maxmatches);
			$bmin = preg_match('/min-width\s*?:\s*?([0-9]+)([a-zA-Z]+)/i', $media, $minmatches);




			$maxmatches = ($bmax) ? $maxmatches : [false, false, false];
			$minmatches = ($bmin) ? $minmatches : [false, false, false];


			if ($srcset) {
				$aSourcesToPreload[] = [
					'media' => $media,
					'type' => $type,
					'srcset' => $srcset,
					'max' => $maxmatches[1],
					'min' => $minmatches[1],
					'maxunit' => $maxmatches[2],
					'minunit' => $minmatches[2],
				];

				// fill these arrays for later use
				array_push($max, $maxmatches[1]);
				array_push($min, $minmatches[1]);
			}
		}

		// THIS SHOUJLD BE REMOVED RIGHT?
		// while ($parent->nodeName == 'source') {

		// 	// get attributes from source element
		// 	$media = ($parent->getAttribute('media')) ? $parent->getAttribute('media')  : '';
		// 	$type = ($parent->getAttribute('type')) ? 'type="' . $parent->getAttribute('type') . '"' : '';
		// 	$srcset  = ($parent->getAttribute('srcset')) ? 'imagesrcset="' . $parent->getAttribute('srcset') . '"' : false;

		// 	// check for crappy max|min-width pattern
		// 	$bmax = preg_match('/max-width\s*?:\s*?([0-9]+)([a-zA-Z]+)/i', $media, $maxmatches);
		// 	$bmin = preg_match('/min-width\s*?:\s*?([0-9]+)([a-zA-Z]+)/i', $media, $minmatches);

		// 	// check $bmin
		// 	$maxmatches = ($bmax) ? $maxmatches : [false, false, false];
		// 	$minmatches = ($bmin) ? $minmatches : [false, false, false];

		// 	if ($srcset) {
		// 		$aSourcesToPreload[] = [
		// 			'media' => $media,
		// 			'type' => $type,
		// 			'srcset' => $srcset,
		// 			'max' => $maxmatches[1],
		// 			'min' => $minmatches[1],
		// 			'maxunit' => $maxmatches[2],
		// 			'minunit' => $minmatches[2],
		// 		];

		// 		// fill these arrays for later use
		// 		array_push($max, $maxmatches[1]);
		// 		array_push($min, $minmatches[1]);
		// 	}
		// 	$parent = $parent->parentNode;
		// }





		sort($max);
		sort($min);

		// if there are no sources, just preload the normal image or srcset
		if (sizeof($aSourcesToPreload) === 0) {
			$srcset = ($element->getAttribute('srcset')) ? 'imagesrcset="' . $element->getAttribute('srcset') . '"' : '';
			$sizes = ($element->getAttribute('sizes')) ? 'imagesizes="' . $element->getAttribute('sizes') . '"' : '';


			if(!$srcset){
				// add a preload link for the main image, cant do this for responsive images (yet??)
				TagStorage::addLinkPreload($this->lcp_img_src, 'image','preload', 20);
			}
			
			

			$preload_links .= '<link fetchpriority="high" rel="preload" href="' . $this->lcp_img_src . '" ' . $srcset . ' ' . $sizes . ' as="image">' . "\n";
			debug::debug('Preload ' . $this->lcp_img_src . ' main image', 3);
		} else {
			debug::debug('Skip preload for main image ' . $this->lcp_img_src . ' because of source', 3);

			// there are sources, lets loop them and maybe calculate the media query
			foreach ($aSourcesToPreload as $source) {
				// check if max and min are both set or are both empty
				if (($source['max'] && $source['min']) || (!$source['max'] && !$source['min'])) {
					// nothing to calculate, just preload
					$preload_links .= '<link fetchpriority="high" rel="preload" ' . $source['srcset'] . ' as="image" ' . $source['media'] . ' ' . $source['type'] . '>' . "\n";
					debug::debug('Preload source ' . $source['srcset'], 3);
				} else if ($source['max'] && !$source['min']) {
					$source['min'] = $max[array_search($source['max'], $max) - 1] + 1;
					$source['media'] .= ' and (min-width:' . $source['min'] . $source['maxunit'] . ')';

					$preload_links .= '<link fetchpriority="high" rel="preload" ' . $source['srcset'] . ' as="image" media="' . $source['media'] . '" ' . $source['type'] . '>' . "\n";
					debug::debug('Preload source ' . $source['srcset'], 3);
					debug::debug('Generate max-width media query (min-width:' . $source['min'] . $source['maxunit'] . ') and (max-width:' . $source['max'] . $source['maxunit'] . ')', 3);
				} else if ($source['min'] && !$source['max']) {
					//find the entry in $max that is larger then $source['min']
					$source['max'] = 1000000000;
					foreach ($max as $value) {
						if ($value > $source['min']) {
							$source['max'] = $value;
							break;
						}
					}
					$source['media'] .= ' and (max-width:' . $source['max'] . $source['maxunit'] . ')';
					$preload_links .= '<link fetchpriority="high" rel="preload" ' . $source['srcset'] . ' as="image"  media="' . $source['media'] . '" ' . $source['type'] . '>' . "\n";
					debug::debug('Preload source ' . $source['srcset'], 3);
					debug::debug('Generate max-width media query (min-width:' . $source['min'] . $source['maxunit'] . ') and (max-width:' . $source['max'] . $source['maxunit'] . ')', 3);
				}
			}
		}


		

		$html = str_replace('</title>', '</title>' . $preload_links, $html);

		return $html;
	}


	/**
	 * find and preload lcp image, $src is matched later to add high fetchprio etc
	 * @param $html
	 * @param $cwv_lcp_selector
	 * @return string $html
	 */
	private function findAndPreloadLCPImage($html, $cwv_lcp_selector)
	{
		debug::debug('Finding LCP element', 2);

		if (!$cwv_lcp_selector) {
			debug::debug('No LCP Selector. This is bad!', 3);
			return $html;
		}

		if (class_exists("DOMDocument")) {
			debug::debug('Using DOMDocument', 2);


			$dom = new \DOMDocument();
			@$dom->loadHTML($html);
			$xpath = new \DOMXPath($dom);


			$this->lcp_img_src = false;

			// lcp used to be a comma separated list of classes, now it is seperated by newlines. 
			$cwv_lcp_selector = str_replace("\n", ',', $cwv_lcp_selector);

			// try to find the lcp element
			foreach (explode(',', $cwv_lcp_selector) as $class) {

				// only try to find the element if we don't have it yet
				if ($this->lcp_img_src === false) {
					debug::debug('Trying to find element with class: ' . $class, 2);

					$class = trim($class);
					$class = ltrim($class, '.');

					// try element directly
					$elements = $xpath->query("//img[contains(@class, '$class')]");
					if ($elements->length > 0) {
						foreach ($elements as $element) {
							$this->lcp_img_src = $element->getAttribute('src');
							if ($this->lcp_img_src) {
								$html = $this->preloadLCPImage($element, $html);
								debug::debug('Found direct img ' . $this->lcp_img_src, 3);
								break;
							}
						}
					}

					// maybe it is a child ?
					if (!$this->lcp_img_src) {
						$elements = $xpath->query("//*[contains(@class, '$class')]//img");
						if ($elements->length > 0) {
							foreach ($elements as $element) {
								$this->lcp_img_src = $element->getAttribute('src');

								if ($this->lcp_img_src) {

									$html = $this->preloadLCPImage($element, $html);
									debug::debug('Found child img ' . $this->lcp_img_src, 3);
									break;
								}
							}
						}
					}

					if (!$this->lcp_img_src) {
						debug::debug('No LCP image found', 3);
					}
				}
			}
		} else {
			debug::debug('DOMDocument not available', 2);
		}

		return $html;
	}




	private function setLazyLoading($html, $cwv_lazy_load_images, $cwv_async_render_images, $cwv_img_width_height)
	{
		debug::debug('Lazy loading', 2);


		preg_match_all('#<img \s*([^>]+)/?>#isU', $html, $matches, PREG_SET_ORDER);
		foreach ($matches as $match) {
			$attrs = HtmlHelper::parseAttr($match[1]);
			$orig_img_html = $match[0];
			$new_img_html = $match[0];

			debug::debug('Found image ' . $attrs['src'], 3);



			// image is LCP element matched by lcp selector (make sure LCP img is a string, not empty)
			if (is_string($this->lcp_img_src) && $attrs['src'] == $this->lcp_img_src) {
				debug::debug('Image is LCP  image, preload, add high fetchprio and async decoding', 4);

				$attrs['loading'] = 'eager';
				$attrs['decoding'] = 'sync';
				$attrs['fetchpriority'] = 'high';

				// remove loading, decoding and fetchpriority attributes
				$new_img_html = preg_replace('/(loading|decoding|fetchpriority)=(["\'])\w*(["\'])\s/', "", $new_img_html);

				// add loading, decoding and fetchpriority attributes
				$new_img_html = str_replace('<img ', '<img data-preload loading="eager" decoding="async" fetchpriority="high" ', $new_img_html);
			} else {

				// lazy loading and async decoding
				if ($cwv_lazy_load_images && !$attrs['loading']) {
					debug::debug('Add native lazy loading', 4);
					$new_img_html = str_replace('<img ', '<img loading="lazy" ', $new_img_html);
				} else {
					debug::debug('Native lazy loading not added', 4);
				}
				if ($cwv_async_render_images && !$attrs['decoding']) {
					debug::debug('Add async decoding', 4);
					$new_img_html = str_replace('<img ', '<img decoding="async" ', $new_img_html);
				}
			}


			$new_img_html = $this->_getImageSize($cwv_img_width_height, $new_img_html, $attrs);

			// finally replace the image!
			$html = str_replace($orig_img_html, $new_img_html, $html);
		}
		return $html;
	}



	private function _getImageSize($cwv_img_width_height, $new_img_html, $attrs)
	{
		// add width and height
		if ($cwv_img_width_height) {

			// check if we have width and height, otherwise set it to false
			$attrs['width'] = $attrs['width'] ?? false;
			$attrs['height'] = $attrs['height'] ?? false;


			// check if we have width and height
			if (!$attrs['width'] || !$attrs['height']) {
				debug::debug('Need to check width and height', 4);

				// stupid test to see if we have something that matches anything remembling content
				if (strlen(@$attrs['src']) > 10) {

					// check if file is local

					// strip site url from src
					$src = $attrs['src'];

					// check if we have a valid url
					if (filter_var($src, FILTER_VALIDATE_URL)) {
						// strip out own url
						if (substr($src, 0, strlen(WP_CWV_SITE_URL)) == WP_CWV_SITE_URL) {
							$src = substr($src, strlen(WP_CWV_SITE_URL));
						}
					}

					// check again if the image is still an url, if so it is not local!
					if (filter_var($src, FILTER_VALIDATE_URL)) {
						debug::debug('Skipping remote image', 4);

						return $new_img_html;
					}


					$src =  rtrim(ABSPATH, '/') . $src;


					try {
						$imginfo = wp_getimagesize($src);

						// can we get img info?
						if ($imginfo) {

							// fix width and height

							/* in only width or height is set one of these factors will be <> 1*/
							$hfactor = ($attrs['width'] > 0) ? $attrs['width'] / $imginfo[0] : 1;
							$wfactor = ($attrs['height'] > 0) ? $attrs['height'] / $imginfo[1] : 1;

							$attrs['height'] = $imginfo[1] * $hfactor * $wfactor;
							$attrs['width'] = $imginfo[0] * $wfactor * $hfactor;

							//remove old width and height
							$new_img_html = preg_replace('/(width|height)=(["\'])\d*(["\'])\s/', "", $new_img_html);

							// set new width and height
							$new_img_html = str_replace('<img ', '<img width="' . $attrs['width'] . '" height="' . $attrs['height'] . '" ', $new_img_html);

							debug::debug('Width (' . $attrs['width'] . ') and height (' . ($attrs['height']) . ') found', 4);
						}
					} catch (\Exception $e) {
						// do nothing
					}
				} else {
					debug::debug('No src found', 4);
				}
			}
		}
		return $new_img_html;
	}
}
