<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}

class IframeStrategy implements StrategyInterface
{

	private $bNeedJS = false;


	public function rewriteOutput($html)
	{
		debug::debug('ENTER IFRAME', 1);

		// variables
		$cwv_lazy_load_iframes = cwv_options::get('cwv_lazy_load_iframes');
		$cwv_lazy_load_iframes_js = cwv_options::get('cwv_lazy_load_iframes_js');

		// rewrite html
		$html = $this->setLazyLoading($html, $cwv_lazy_load_iframes, $cwv_lazy_load_iframes_js);
		$html = $this->addJSLazyScript($html, $cwv_lazy_load_iframes_js);

		return $html;
	}







	/**
	 * inject lazy loading script
	 * @param $html
	 * @param $cwv_lazy_load_iframes
	 * @return string $html
	 */
	private function addJSLazyScript($html, $cwv_lazy_load_iframes_js)
	{

		debug::debug('Iframe lazy loading script ', 2);

		if ($cwv_lazy_load_iframes_js && $this->bNeedJS){
			debug::debug('added to page ', 3);

			$script = '<script>let _cwv_iframe_observer=new IntersectionObserver((e,r)=>{e.forEach(e=>{e.isIntersecting&&(e.target.src=e.target.dataset.src,r.unobserve(e.target))})});document.querySelectorAll("iframe[data-src]").forEach(e=>{_cwv_iframe_observer.observe(e)});</script>';
			return str_replace('</body>', $script . '</body>', $html);
		}
		debug::debug('skipped cause of no iframes ', 3);

		return $html;
	}


	private function setLazyLoading($html, $cwv_lazy_load_iframes, $cwv_lazy_load_iframes_js)
	{
		preg_match_all('#<iframe \s*([^>]+)/?>#isU', $html, $matches, PREG_SET_ORDER);

		foreach ($matches as $match) {
			$attrs = HtmlHelper::parseAttr($match[1]);
			$orig_iframe_html = $match[0];
			$new_iframe_html = $match[0];

			debug::debug('iFrame src ' . @$attrs['src'], 2);
			// lazy loading and async decoding
			if ($cwv_lazy_load_iframes && !@$attrs['loading']) {
				debug::debug('Applied native lazy loading ' . @$attrs['src'], 3);
				$new_iframe_html = str_replace('<iframe ', '<iframe loading="lazy" ', $new_iframe_html);
			}


			if ($cwv_lazy_load_iframes_js) {
				
				debug::debug('Applied JS lazy loading ' . @$attrs['src'], 3);
				
				$this->bNeedJS = true;

				$new_iframe_html = str_replace('<iframe ', '<iframe data-src="' . @$attrs['src'] . '" ', $new_iframe_html);

				// remove src and srcset from $new_iframe_html
				$new_iframe_html = preg_replace('/(src)=(["\'])\d*(["\'])\s/', "", $new_iframe_html);
			}


			// finally replace the image!
			$html = str_replace($orig_iframe_html, $new_iframe_html, $html);
		}
		return $html;
	}
}
