<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}

class ResourceHintsStrategy implements StrategyInterface
{


	public function rewriteOutput($html)
	{
		debug::debug('ENTER RESOURCE HINTS', 1);

		$cwv_page_remove_dns_prefetch = cwv_options::get('cwv_page_remove_dns_prefetch');
		$cwv_page_remove_preconnect = cwv_options::get('cwv_page_remove_preconnect');
		$cwv_page_remove_prefetch = cwv_options::get('cwv_page_remove_prefetch');
		$cwv_page_remove_preload = cwv_options::get('cwv_page_remove_preload');


		$html = $this->removeResourceHints($html, $cwv_page_remove_dns_prefetch, $cwv_page_remove_preconnect, $cwv_page_remove_prefetch, $cwv_page_remove_preload);

		return $html;
	}


	public function addLatePreloads($html)
	{
		$preloads = PreloadDB::findAll();

		$html = $this->addResourceHints($html, $preloads);

		return $html;
	}


	/**
	 * Add custom resource hints
	 * 
	 * @todo: check if resource hints match, require crossorogin etc etc
	 *
	 * @param string $html
	 * @param array $preloads
	 * @return string $html
	 */
	private function addResourceHints($html, $preloads)
	{
		if (count($preloads) > 0) {
			debug::debug('Custom resource hints asd', 2);

			$preload_links = '';
			foreach ($preloads as $preload) {
				$as = '';
				$crossorigin = '';

				// preloads need an as
				if ($preload->preloadtype == 'preload') {
					$as = ' as="' . $preload->preloadfiletype . '"';

					// font needs crossorigin
					if ($preload->preloadfiletype == 'font') {
						$crossorigin = ' crossorigin';
					}
				}

				// the resource hint
				if($preload->preloadloacation == 'header'){
					TagStorage::addLinkPreload($preload->preloadlink, $preload->preloadfiletype, $preload->preloadtype, 30);
				} 

				$preload_links .= '<link fetchpriority="high" rel="' . $preload->preloadtype . '" href="' . trim($preload->preloadlink) . '" '.$as.$crossorigin.' />';
				debug::debug('rel="' . $preload->preloadtype . '" href="' . trim($preload->preloadlink) . '" '.$as.$crossorigin, 3);
			}

			// add to html
			$html = str_replace('</title>', '</title>' . $preload_links, $html);
		}

		return $html;
	}



	/**
	 * Remove dns-prefetch and preconnect
	 *
	 * @param string $html
	 * @param bool $cwv_page_remove_dns_prefetch
	 * @param bool $cwv_page_remove_preconnect
	 * @return string $html
	 */
	private function removeResourceHints($html, $cwv_page_remove_dns_prefetch, $cwv_page_remove_preconnect, $cwv_page_remove_prefetch, $cwv_page_remove_preload)
	{

		// no need for loop?
		if ($cwv_page_remove_dns_prefetch || $cwv_page_remove_preconnect) {

			debug::debug('Remove resource hints ', 2);


			preg_match_all('#<link([^>]+)>#isU', $html, $matches, PREG_SET_ORDER);
			foreach ($matches as $match) {

				$attrs = HtmlHelper::parseAttr($match[1]);
				$orig_link_html = $match[0];
				$new_link_html = $match[0];

				// remove dns prefetch
				if ($attrs['rel'] == 'dns-prefetch' && $cwv_page_remove_dns_prefetch) {
					debug::debug($orig_link_html, 3);
					$new_link_html = '';
				}

				// remove preconnect
				if ($attrs['rel'] == 'preconnect' && $cwv_page_remove_preconnect) {
					debug::debug($orig_link_html, 3);
					$new_link_html = '';
				}
				// remove prefetch
				if ($attrs['rel'] == 'prefetch' && $cwv_page_remove_prefetch) {
					debug::debug($orig_link_html, 3);
					$new_link_html = '';
				}
				// remove preload
				if ($attrs['rel'] == 'preload' && $cwv_page_remove_preload) {
					debug::debug($orig_link_html, 3);
					$new_link_html = '';
				}

				// finally replace all stylesheets
				$html = str_replace($orig_link_html, $new_link_html, $html);
			}
		}

		return $html;
	}
}
