<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}

class HtmlStrategy implements StrategyInterface
{


	public function rewriteOutput($html)
	{

		debug::debug('ENTER HTML', 1);


		$cwv_page_minify = cwv_options::get('cwv_page_minify');
		$cwv_footer_content_visibility = cwv_options::get('cwv_footer_content_visibility');
		$cwv_footer_selector = cwv_options::get('cwv_footer_selector');
		$cwv_prefetch_links = cwv_options::get('cwv_prefetch_links');
		$cwv_prefetch_prio = cwv_options::get('cwv_prefetch_prio');


		$html = $this->addFooterContentVisibility($html, $cwv_footer_content_visibility, $cwv_footer_selector);
		$html = $this->minifyHTML($html, $cwv_page_minify);
		$html = $this->prefetchLinks($html, $cwv_prefetch_links,$cwv_prefetch_prio);

		return $html;
	}



	private function prefetchLinks($html,$cwv_prefetch_links,$cwv_prefetch_prio){
		if ($cwv_prefetch_links) {
			debug::debug('Prefetch links, injecting speculation rules!', 2);
			$type = [1 => 'prefetch', 2 => 'prerender'][$cwv_prefetch_links];
			$eagerness = [1 => 'moderate', 2 => 'eager', 3 => 'conservative'][$cwv_prefetch_prio];

			$prerenderRules = '{"'.$type.'": [{"source": "document","where": {"and": [{"href_matches": '.json_encode(WP_CWV_SITE_URL.'/*').'},{ "not": { "selector_matches": ".no-prerender" } },{ "not": { "href_matches": "?" } },{ "not": { "href_matches": "#" } }]},"eagerness": "'.$eagerness.'"}]}';
 			$script = '<script type="speculationrules">'.$prerenderRules.'</script>';
			
			//$script = '<script>window.addEventListener(\'load\',function(){setTimeout(function(){var cwv_pfl = document.createElement("script");cwv_pfl.src = "' . WP_CWV_PLUGIN_DIR . 'public/js/cwv_prefetchlinks.js?ver=' . WP_CWV_VERSION . '", document.body.appendChild(cwv_pfl);},900); });</script>';
			$html = str_replace('</body', $script . '</body', $html);
		}

		return $html;


	}


	/**
	 * @param $html
	 * @param $cwv_page_minify
	 * @return string $html
	 */
	private function minifyHTML($html, $cwv_page_minify)
	{
		if ($cwv_page_minify) {
			debug::debug('Minify HTML', 2);
			return Minify_HTML::minify($html);
		}
		debug::debug('No HTML minification', 2);

		return $html;
	}

	/**
	 * @param $html
	 * @param $cwv_page_remove_dns_prefetch
	 * @param $cwv_page_remove_preconnect
	 * @return string $html
	 */
	private function addFooterContentVisibility($html, $cwv_footer_content_visibility, $cwv_footer_selector)
	{
		if ($cwv_footer_content_visibility) {
			debug::debug('Content visibility', 2);

			$orig_tag = HtmlHelper::getOpeningTagBySelector($html, $cwv_footer_selector);

			debug::debug('Applied to ' . $orig_tag, 3);

			$new_tag = $orig_tag;
			$attrs = HtmlHelper::parseAttr($orig_tag);

			// remove old classes
			$new_tag = preg_replace('/(class)=(["\'])(.*)(["\'])\s?/', "", $new_tag);

			// add class to $new_tag
			$new_tag = str_replace('>', ' class="' . $attrs['class'] . ' cwv-cva">', $new_tag);

			// add style to head
			TagStorage::addCss('.cwv-cva{content-visibility:auto;}');



			// finally replace the tag!
			$html = str_replace($orig_tag, $new_tag, $html);
		}

		return $html;
	}
}
