<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}

class FontStrategy implements StrategyInterface
{


    public function rewriteOutput($html)
    {

        debug::debug('ENTER FONTS', 1);


        $cwv_remove_google_fonts = cwv_options::get('cwv_remove_google_fonts');
        $cwv_text_rendering = cwv_options::get('cwv_text_rendering');
        $cwv_lazy_load_icons = cwv_options::get('cwv_lazy_load_icons');
        $cwv_lazy_load_icons_classlist = cwv_options::get('cwv_lazy_load_icons_classlist');


        $html = $this->removeGoogleFonts($html, $cwv_remove_google_fonts);
        $html = $this->setTextRendering($html, $cwv_text_rendering);
        $html = $this->lazyLoadIcons($html, $cwv_lazy_load_icons, $cwv_lazy_load_icons_classlist);


        return $html;
    }



    /**
     * add js lazy script
     * @param $html
     * @param $cwv_lazy_load_images_js
     * @return string $html
     */
    private function lazyLoadIcons($html, $cwv_lazy_load_icons, $cwv_lazy_load_icons_classlist)
    {


        if (isset($cwv_lazy_load_icons) && $cwv_lazy_load_icons == 1) {


            $classlist = ltrim($cwv_lazy_load_icons_classlist . ',.fa,.fas', ',');

            debug::debug('Adding lazy load Icons CSS (' . $classlist . ') and script!', 2);

            $style = "\n".'<style id="lazyicons" data-no-optimize>' . $classlist . '{display:none!important;}</style>'."\n";
            $script = "<script>window.addEventListener('DOMContentLoaded', function() {document.getElementById('lazyicons').remove();});</script>";
            $html = str_replace('</head>', $style . $script . '</head>', $html);
        }

        return $html;
    }



    /**
     * Adds custom font preloads
     * @param string $html
     * @return string $html
     */
    private function setTextRendering($html, $cwv_text_rendering)
    {
        if ($cwv_text_rendering) {
            debug::debug('Optimize text renderings', 2);
            TagStorage::addCss('body {text-rendering: optimizeSpeed;}');
        };

        return $html;
    }





    /**
     * Removes CSS, JS, preconnect and dns-prefetch for Google Fonts & typekit
     * @param string $html
     * @return string $html
     */
    private function removeGoogleFonts($html, $cwv_remove_google_fonts)
    {
        if ($cwv_remove_google_fonts) {

            // use.typekit.net, fonts.googleapis.com, fonts.gstatic.com and webfont loader

            debug::debug('Remove Google Fonts', 2);

            /* Links, includes css & resource hints */
            $html = preg_replace('/<link[^>]+href=["\']https:\/\/fonts\.googleapis\.com[^>]+>/i', '', $html);
            $html = preg_replace('/<link[^>]+href=["\']https:\/\/fonts\.gstatic\.com[^>]+>/i', '', $html);
            $html = preg_replace('/<link[^>]+href=["\']https:\/\/use\.typekit\.net[^>]+>/i', '', $html);

            /* Scripts */
            $html = preg_replace('/<script[^>]+src=["\']https:\/\/use\.typekit\.net[^>]+><\/script>/i', '', $html);

            /* webfont loader, if sites are still using this all hope is lost */
            $html = preg_replace('/<script[^>]+src=["\']https:\/\/ajax\.googleapis\.com\/ajax\/libs\/webfont\/[^>]+><\/script>/i', '', $html);
        }

        return $html;
    }

   
}
