<?php

namespace WPCWV;


if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}

class StyleRewriteBase
{


	public function combineCSS($html)
	{

		debug::debug('ENTER COMBINE CSS', 1);

		$cwv_css_lower_regex = cwv_options::get('cwv_css_lower_regex');
		$compress_css = cwv_options::get('compress_css');
		$cwv_combine_css = cwv_options::get('cwv_combine_css');
		$cwv_combine_inline_css = cwv_options::get('cwv_combine_inline_css');

		if ($cwv_combine_css && FileSystem::dir_is_writable('cachedir')) {
			debug::debug('Combine CSS enabled & cache dir is writable', 2);

			$sCss = '';
			$aCssFiles = [];
			$sCssHash = '';


			// old regex that omitted inline style
			//preg_match_all('#<link([^>]+)>#isG', $html, $matches, PREG_SET_ORDER);



			##  External files
			preg_match_all('#<link([^>]+)>|<style\b[^>]*>([\s\S]*?)<\/style>#is', $html, $matches, PREG_SET_ORDER);

			debug::debug('No of matches:' . (int)sizeof($matches));


			foreach ($matches as $match) {

				// check if it is a style or link tag
				if (substr($match[0], 0, 6) == '<style') {
					debug::debug('Found inline' . substr($match[2], 0, 20), 2);
					$attrs = HtmlHelper::parseAttr($match[0]);

					// check if we need to skip this style because 'data-no-optimize' is in $match[0]
					if ($cwv_combine_inline_css == 0) {
						debug::debug('Skipped because of settings', 3);
					} else if (strpos($match[0], 'data-no-optimize') !== false) {
						// skip
						debug::debug('Skipped because of data-no-optimize', 3);
					} else {

						$sCssHash .= substr($match[2], 0, 30);
						// just add the inline style
						$aCssFiles[] = ['type' => 'inline', 'content' => $match[2], 'hash' => md5($sCssHash)];

						// remove css from page
						$html = str_replace($match[0], '', $html);
					}
				} else {

					$attrs = HtmlHelper::parseAttr($match[1]);
					if ($attrs['rel'] == 'stylesheet' && $attrs['media'] != 'print') {
						$orig_css_html = $match[0];
						$new_css_html = $match[0];

						debug::debug('Found ' . $attrs['href'], 2);


						if ($cwv_css_lower_regex && (cwvh::isAllowedByRegex($cwv_css_lower_regex, $attrs['href']))) {
							// allow this file
							debug::debug('Is allowed', 3);
						} else {
							debug::debug('Removed', 3);

							$sCssHash .= preg_replace('/\?.*/', '', $attrs['href']);
							//remove query string from $attrs['href']

							$aCssFiles[] = ['type' => 'file', 'content' => $attrs['href'], 'hash' => md5($sCssHash)];
							// remove here!
							$new_css_html = '';
						}
						// finally replace all stylesheets
						$html = str_replace($orig_css_html, $new_css_html, $html);
					}
				}
			}




			## Inline CSS
			debug::debug('Css hash: ' . $sCssHash, 3);

			$sCombinesCssHash = md5($sCssHash);




			/**
			 * SMART CSS NAMING
			 */

			$styleSheetsToInsertHtml = '';


			if ($cwv_combine_css == 3) {
				if (file_exists(WP_CONTENT_DIR . '/cache/wp_cwv/css/' . $sCombinesCssHash . '-summary.json')) {

					$aSummary = json_decode(file_get_contents(WP_CONTENT_DIR . '/cache/wp_cwv/css/' . $sCombinesCssHash . '-summary.json'), true);

					//summary is here, we can assume that all files are there
				} else {
					foreach ($aCssFiles as $k => $aCssFile) {

						if ($aCssFile['type'] == 'inline') {
							$aCssFiles[$k]['css'] = $aCssFile['content'];
						} else {
							$aCssFiles[$k]['css'] = $this->fetchStyleSheet($aCssFile['content']);
						}

						//get size in kb
						$aCssFiles[$k]['size'] = strlen($aCssFiles[$k]['css']) / 1024;
					}

					$curSize = 0;
					$curHash = '';
					$curCSS = '';
					$aSummary = [];



					foreach ($aCssFiles as $cssCount => $aCssFile) {
						$curHash .= $aCssFile['hash'];
						$curCSS .= $aCssFile['css'];

						if (($aCssFile['size'] + $curSize < 40) && ($cssCount != sizeof($aCssFiles) - 1)) {

							// go to the next file
						} else {

							$curHash = md5($curHash);
							// create a new file
							$bool = file_put_contents(WP_CONTENT_DIR . '/cache/wp_cwv/css/' . $curHash . '.css', $curCSS);
							if ($bool ===  false) {
								debug::debug('ERROR: Could not write CSS file', 4);
							}
							$aSummary[$cssCount] = WP_CONTENT_URL.'/cache/wp_cwv/css/' . $curHash . '.css';


							$curHash = '';
							$curCSS = '';
							$curSize = 0;
						}
					}

					// save summary
					$bool = file_put_contents(WP_CONTENT_DIR . '/cache/wp_cwv/css/' . $sCombinesCssHash . '-summary.json', json_encode($aSummary));
				}

				foreach ($aSummary as $i => $cssFile) {
					$styleSheetsToInsertHtml .= '<link id="css-combined-' . $i . '" rel="stylesheet" href="' . $cssFile . '" />';
					TagStorage::addLinkPreload($cssFile, 'style', 'preload', 10);
				}
			}


			/**
			 * END SMART CSS NAMING
			 */

			if ($cwv_combine_css == 1 || $cwv_combine_css == 2) {
				if (file_exists(WP_CONTENT_DIR . '/cache/wp_cwv/css/' . $sCombinesCssHash . '-0.css')) {
					debug::debug('Found first CSS combined file /cache/wp_cwv/css/' . $sCombinesCssHash . '-0.css', 2);

					// assume that all files are there
				} else {
					debug::debug('Need to combine CSS files!', 2);

					foreach ($aCssFiles as $aCssFile) {

						if ($aCssFile['type'] == 'inline') {
							$sCss .= "\n/* --------------- START inline --------------- */ \n";
							$sCss .= $aCssFile['content'];
							$sCss .= "\n/* --------------- END inline --------------- */ \n";
						} else {
							$sCss .= "\n/* --------------- START " . $aCssFile['content'] . " --------------- */ \n";
							$sCss .= $this->fetchStyleSheet($aCssFile['content']);
							$sCss .= "\n/* --------------- END " . $aCssFile['content'] . " --------------- */ \n";
						}
					}

					@mkdir(WP_CONTENT_DIR . '/cache/wp_cwv/css/', 0777, true);

					// split css?
					if ($cwv_combine_css == 2) {
						// single file (for whatever reason!)
						debug::debug('Create a single CSS file', 2);

						$aParts[] = $sCss;
					} else {
						// auto number of files
						$aParts = $this->split_css($sCss);
						debug::debug('Create ' . count($aParts) . ' CSS files', 2);
					}

					// loop and write css parts, maybe compress each part
					foreach ($aParts as $i => $sPart) {
						debug::debug('Create CSS File /cache/wp_cwv/css/' . $sCombinesCssHash . '-' . $i . '.css', 3);
						if ($compress_css) {
							// compress
							$compressor = new Minify_CSS;
							$compressor->setMemoryLimit('256M');
							$compressor->setMaxExecutionTime(120);
							$compressor->setPcreBacktrackLimit(3000000);
							$compressor->setPcreRecursionLimit(150000);
							$tmp = $compressor->run($sPart);
							debug::debug('Compression: strlen = ' . strlen($tmp) . ' compressed vs ' . strlen($sPart) . ' uncompressed', 4);

							// did it do a good job?
							$sPart = (strlen($tmp) > 100 ? $tmp : $sPart);
						} else {
							debug::debug('Compression disabled ', 4);
						}

						// save css file
						$bool = file_put_contents(WP_CONTENT_DIR . '/cache/wp_cwv/css/' . $sCombinesCssHash . '-' . $i . '.css', $sPart);
						if ($bool ===  false) {
							debug::debug('ERROR: Could not write CSS file', 4);
						}
					}
				}



				// insert stylesheet
				//$styleSheetsToInsertHtml = '';
				for ($i = 0; $i <= 6; $i++) {
					if (file_exists(WP_CONTENT_DIR . '/cache/wp_cwv/css/' . $sCombinesCssHash . '-' . $i . '.css')) {
						debug::debug('Insert Stylesheet into head: '.WP_CONTENT_URL.'/cache/wp_cwv/css/' . $sCombinesCssHash . '-' . $i . '.css', 2);
						$styleSheetsToInsertHtml .= '<link id="css-combined-' . $i . '" rel="stylesheet" href="'.WP_CONTENT_URL.'/cache/wp_cwv/css/' . $sCombinesCssHash . '-' . $i . '.css" />';

						// add it to response header preloads
						TagStorage::addLinkPreload(WP_CONTENT_URL.'/cache/wp_cwv/css/' . $sCombinesCssHash . '-' . $i . '.css', 'style', 'preload', 10);
					}
				}
			}

			// try inserting after title, best place icm preload links later on
			$html = str_replace('</title>', '</title>' . $styleSheetsToInsertHtml, $html, $count);

			if ((int)$count === 0) {
				debug::debug('Could not find title tag, placing at end of head', 4);

				$html = str_replace('</head>', $styleSheetsToInsertHtml . '</head>', $html);
			}
		}


		return $html;
	}





	public function fetchStyleSheet($url)
	{

		$url = CssUtilities::cwv_normalize_href($url, WP_CWV_SITE_URL . $_SERVER['REQUEST_URI']);

		$cwv_auth_username = cwv_options::get('cwv_auth_username');
		$cwv_auth_password = cwv_options::get('cwv_auth_password');
		$aCFG = [
			'reject_unsafe_urls' => true,
			'timeout' => 15,
			'user-agent' => 'Mozilla/5.0 (X11; CrOS x86_64 14541.0.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36'
		];

		if ($cwv_auth_password && $cwv_auth_username) {
			$aCFG['headers']['Authorization'] =   'Basic ' . base64_encode($cwv_auth_username . ':' . $cwv_auth_password);
		}


		$response = wp_remote_get($url, $aCFG);

		if (is_wp_error($response)) {
			return "\n/* " . $url . "\n\n" . $response->get_error_message() . ' */';
		}

		if (!$response || is_wp_error($response)) {
			return false;
		} else {
			if (wp_remote_retrieve_response_code($response) == 200) {
				$data = wp_remote_retrieve_body($response);

				if (preg_match("/\<\!DOCTYPE/i", $data) || preg_match("/<\/\s*html\s*>/i", $data)) {
					return false;
				} else if (!$data) {
					return "/* empty */";
				} else {
					return CssUtilities::rewritePaths($data, $url);
					//return $data;
				}
			} else if (wp_remote_retrieve_response_code($response) == 404) {
				if (preg_match("/\.css/", $url)) {
					return "/*404*/";
				} else {
					return "<!-- 404 -->";
				}
			}
		}
	}

	/**
	 * @param $html
	 * @return array
	 * @todo: fix the last part that will be too small!
	 */
	private function split_css($sCss)
	{

		// original target length
		$targetlength = 60000;

		// css length
		$css_length = strlen($sCss);

		// numnber of parts
		$n_parts = round($css_length / $targetlength);
		$n_parts = $n_parts == 0 ? 1 : $n_parts;
		if ($n_parts > 6) $n_parts = 6; // max 6 parts 

		// new target length
		$targetlength = round($css_length / $n_parts);

		// initial values
		$curpartlength = 0;
		$part = '';
		$parts = array();



		for ($i = 0; $i < $css_length; $i++) {

			$curpartlength++;

			// last part, just return remaining css
			if (sizeof($parts) == $n_parts - 1) {
				$parts[] = $sCss;
				return $parts;
			}


			// maybe we got a closing bracket
			if (substr($sCss, $i, 1) == '}') {
				$part = substr($sCss, 0, $i + 1);

				// near target length
				if ($curpartlength++ > $targetlength) {

					// check if we have a balanced bracket
					if (substr_count($part, '}') == substr_count($part, '{')) {


						// add part to array and reset
						$parts[] = $part;
						$sCss = substr($sCss, $i + 1);
						$css_length = strlen($sCss);
						$i = 0;
						$curpartlength = 0;
					}
				}
			}
		}

		$parts[] = $sCss;

		return $parts;
	}
}
