<?php

namespace WPCWV;


if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}

/**
 * Class TagStorage
 * saves tags that should be added during the final output
 * - better anc centralized placement control
 * - combine the tags in a single <style> or <script>
 * - better sort the tags
 */

class TagStorage
{
    private static $aCss = [];
    private static $aPreloads = [];

    /**
     * Adds a CSS string to the storage
     * @param string $css
     */
    public static function addLinkPreload($preload, $as, $rel, $order = 10)
    {
        self::$aPreloads[] = ['preload' => $preload, 'as' => $as, 'order' => $order, 'rel' => $rel];
    }

    public static function getLinkPreload(){
        $a = [];
        foreach(self::$aPreloads as $preload){
            if($preload['rel'] == 'preconnect'){
                $a[] = '<' . $preload['preload'] . '>; rel='.$preload['rel'];
            } else {
                $a[] = '<' . $preload['preload'] . '>; rel='.$preload['rel'].'; as=' . $preload['as'];
            }
        }
        return implode(', ', $a);
    }


    /**
     * Adds a CSS string to the storage
     * @param string $css
     */
    public static function addCss($css, $order = 10)
    {
        self::$aCss[] = ['css' => $css, 'order' => $order];
    }

    public static function toHtml($html)
    {
        debug::debug('ENTER TAGSTORAGE', 1);

        // sort css
        usort(self::$aCss, function ($a, $b) {
            return $a['order'] <=> $b['order'];
        });

        debug::debug('found ' . count(self::$aCss) . ' css chunks to insert', 2);


        // check if </head> is present
        $placement =  (strpos($html, '</head>') === false) ? 'title' : 'head';

        debug::debug('best placement seems to be ' . $placement . '(this should say \'head\')', 2);


        if ($placement == 'title') {
            // add css after the title
            $html = str_replace('</title>', '</title><style id="cwv-all-styles">' . implode('', array_column(self::$aCss, 'css')) . '</style>', $html);
        } else {
            // be safe(r) and and the css to the end of the head
            $html = str_replace('</head>', '<style id="cwv-all-styles">' . implode('', array_column(self::$aCss, 'css')) . '</style></head>', $html);
        }

        return $html;
    }



    public static function getCssAsString()
    {
        return implode(' ', self::$aCss);
    }
}
