<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}


class HtmlHelper
{

    public static function parseAttr($str)
    {
        $attrs = array();
        preg_match_all('#([\w-]+)=(["\'])([^\2]*)\2#isU', $str, $matches, 2);
        foreach ($matches as $match) {
            $attrs[$match[1]] = trim($match[3]);
        }
        return $attrs;
    }

    public static function getOpeningTagBySelector($html, $selector)
    {
        $type = substr($selector, 0, 1);

        switch ($type) {
            case '#':
                $selector = substr($selector, 1);
                $pattern = '#<\s*(\w+)([^>]*)(\sid\s*=\s*"([^"]*\b' . $selector . '\b[^"]*)")[^>]*>#isU';
                break;
            case '.':
                $selector = substr($selector, 1);
                $pattern = '#<\s*(\w+)([^>]*)(\sclass\s*=\s*"([^"]*\b' . $selector . '\b[^"]*)")[^>]*>#isU';
                break;
            default:
                $pattern = '#<' . $selector . '(\s+[^>]+)?>#isU';
                break;
        }

        preg_match($pattern, $html, $matches);
        return $matches[0];
    }


}
