<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}


class cwvh
{

	public static function isAllowedByRegex($regex, $what = false)
	{
		if ($what == false) {
			$what = $_SERVER['REQUEST_URI'];
		}
		$regex = trim(stripslashes($regex));
		if ($regex) {
			if (@preg_match('/' . $regex . '/i', "") === false) {
				return false;
			} else
				return (@preg_match('/' . $regex . '/i', $what) > 0) ? true : false;
		}
		return false;
	}


	public static function getCachePathInfo($mUrl)
	{

		$sRelPath = trim($_SERVER['HTTP_HOST']).trim(str_replace(home_url(), '', $mUrl), '/');
		$sHash = md5($sRelPath) . '.html';
		$sAbsPath = WP_CONTENT_DIR . '/cache/wp_cwv/html/';

		return ['filename' => $sHash, 'abspath' => $sAbsPath];
	}







	static function fetch($url)
	{
		//user agent is very necessary, otherwise some websites like google.com wont give zipped content
		$opts = array(
			'http' => array(
				'method' => "GET",
				'header' => "Accept-Language: en-US,en;q=0.8rn" .
					"Accept-Encoding: gzip,deflate,sdchrn" .
					"Accept-Charset:UTF-8,*;q=0.5rn" .
					"User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:19.0) Gecko/20100101 Firefox/19.0 FirePHP/0.4rn"
			)
		);

		$context = stream_context_create($opts);
		$content = wp_remote_get($url, false, $context);

		//If http response header mentions that content is gzipped, then uncompress it
		foreach ($http_response_header as $c => $h) {
			if (stristr($h, 'content-encoding') and stristr($h, 'gzip')) {
				//Now lets uncompress the compressed data
				$content = gzinflate(substr($content, 10, -8));
			}
		}

		return $content;
	}


	static function isPluginActive($plugin)
	{
		return in_array($plugin, (array) get_option('active_plugins', array())) || self::isPluginActiveForNetwork($plugin);
	}




	static function isPluginActiveForNetwork($plugin)
	{
		if (!is_multisite())
			return false;

		$plugins = get_site_option('active_sitewide_plugins');
		if (isset($plugins[$plugin]))
			return true;

		return false;
	}


	static function ignored($html,$urlPartsIgnored)
	{

		if(strlen($urlPartsIgnored) > 0){
			$urlPartsIgnored = explode("|", $urlPartsIgnored);
			foreach ($urlPartsIgnored as $part) {
				if (strpos($_SERVER['REQUEST_URI'], $part) !== false) {
					return 'url ignored by '.$part;
				}
			}

		}

		if(strlen($html) < 500){
			return 'html size';
		}

		// logged not admin
		if (is_user_logged_in() && !current_user_can('administrator')) {
			return 'logged in';
		}


		if (defined('DONOTCACHEPAGE')) {
			return 'do not cache';
		}


		if (isset($_COOKIE['woocommerce_cart_hash'])) {
			return 'has cart';
		}

		$list = array(
			"\/wp\-comments\-post\.php",
			"\/wp\-login\.php",
			"\/robots\.txt",
			"\/wp\-cron\.php",
			"\/wp\-content",
			"\/wp\-admin",
			"\/wp\-includes",
			"\/index\.php",
			"\/xmlrpc\.php",
			"\/wp\-api\/",
			"leaflet\-geojson\.php",
			"\/clientarea\.php",
			"\/cart",
			"\/checkout",
			"\/feed\/$"
		);
		if (self::isPluginActive('woocommerce/woocommerce.php')) {
			global $post;

			if (isset($post->ID) && $post->ID) {
				if (function_exists("wc_get_page_id")) {
					$woocommerce_ids = array();

					array_push($woocommerce_ids, wc_get_page_id('cart'), wc_get_page_id('checkout'), wc_get_page_id('receipt'), wc_get_page_id('confirmation'), wc_get_page_id('myaccount'));

					if (in_array($post->ID, $woocommerce_ids)) {
						return true;
					}
				}
			}

			array_push($list, "\/cart\/?$", "\/checkout", "\/receipt", "\/confirmation", "\/wc-api\/");
		}

	

		if (preg_match("/" . implode("|", $list) . "/i", $_SERVER["REQUEST_URI"])) {
			return 'in default list';
		}

		return false;
	}
}
