<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}

class CWVCache
{
	public function cache($html,$link)
	{
		debug::debug('ENTERING CACHE ', 1);

		$cwv_bypage_cache = cwv_options::get('cwv_bypage_cache');

		if (cwv_options::get('wp_cwv_page_cache') == 1) {
			$isPageExcluded = $this->isPageExcluded($cwv_bypage_cache);
			if ($isPageExcluded) {
				return;
			}

			$aCacheInfo = cwvh::getCachePathInfo($_SERVER['REQUEST_URI']);
			@mkdir(WP_CONTENT_DIR . '/cache/wp_cwv/html/', 0777, true);
			file_put_contents(WP_CONTENT_DIR . '/cache/wp_cwv/html/' .  $aCacheInfo['filename'], $html);

			// add preload
			if($link != ''){
				file_put_contents(WP_CONTENT_DIR . '/cache/wp_cwv/html/' .  $aCacheInfo['filename'].'-link', $link);
			}

		} else {
			debug::debug('No cache enabled ', 2);
		}
	}


	/**
	 * This function checks if the current page is excluded from cache.
	 * It uses the cwv_bypage_cache option to check if the current page
	 * matches any of the patterns stored in the option.
	 *
	 * @param string $cwv_bypage_cache
	 * @return bool
	 */

	private function isPageExcluded($cwv_bypage_cache)
	{
		debug::debug('Checking cache bypass ', 2);
		if (!empty($cwv_bypage_cache)) {

			foreach (explode("\n", $cwv_bypage_cache) as $pattern) {
				$pattern = trim($pattern);
				if (!empty($pattern)) {
					if (stristr($_SERVER['REQUEST_URI'], $pattern)) {
						debug::debug('Cache bypassed for ' . $pattern, 3);
						return true;
					}
				}
			}
		};
		debug::debug('No bypass ', 3);

		return false;
	}
}
