<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}

class cwv_script_rules
{

    public static function init()
    {
        add_action('wp_ajax_wp_cwv_get_script_rules', 'WPCWV\cwv_script_rules::wp_cwv_get_script_rules');
        add_action('wp_ajax_wp_cwv_delete_script_rule', 'WPCWV\cwv_script_rules::wp_cwv_delete_script_rule');
    }


    public static function wp_cwv_get_script_rules()
    {
        $oCriticalRules = ScriptRulesDB::findAll();
        echo '<div class="table-responsive">';
        echo '    <table class="bordered form-xtable">';
        echo '      <tr valign="top">';
        echo '          <th>Regex</th>';
        echo '          <th>Trigger</th>';
        echo '          <th>Selector</th>';
        echo '          <th></th>';
        echo '      </tr>';

        foreach ($oCriticalRules as $oCriticalRule) {
            echo '<tr valign="top">';
            echo '      <td width="35%"><input type="text" name="scriptrules[' . $oCriticalRule->id . '][scriptregex]" value="' . esc_attr($oCriticalRule->scriptregex) . '" /></td>';
            echo '      <td>';
            echo '          <select name="scriptrules[' . $oCriticalRule->id . '][scripttrigger]">';
            echo '              <option ' . (($oCriticalRule->scripttrigger == 'intersectionobserver') ? 'selected' : '') . ' value="intersectionobserver">Scroll into view</option>';
            echo '              <option ' . (($oCriticalRule->scripttrigger == 'hover') ? 'selected' : '') . ' value="hover">Hover / Click</option>';
            echo '              <option ' . (($oCriticalRule->scripttrigger == 'idle') ? 'selected' : '') . ' value="idle">Load when browser is idle</option>';
            echo '              <option ' . (($oCriticalRule->scripttrigger == 'interaction') ? 'selected' : '') . ' value="interaction">Load on Browser Interaction</option>';
            echo '              <option ' . (($oCriticalRule->scripttrigger == 'async') ? 'selected' : '') . ' value="async">Load Async</option>';
            echo '              <option ' . (($oCriticalRule->scripttrigger == 'defer') ? 'selected' : '') . ' value="defer">Load Deferred</option>';
            echo '              <option ' . (($oCriticalRule->scripttrigger == 'block') ? 'selected' : '') . ' value="block">Load render blocking</option>';
            echo '              <option ' . (($oCriticalRule->scripttrigger == 'remove') ? 'selected' : '') . ' value="remove">Remove this script</option>';
            echo '          </select>';
            echo '      </td>';
            echo '      <td><input type="text" name="scriptrules[' . $oCriticalRule->id . '][scriptselector]" value="' . esc_attr($oCriticalRule->scriptselector) . '" /></td>';
            echo '      <td><span class="deleterule button button-primary" data-id="' . $oCriticalRule->id . '">X</span></td>';
            echo '</tr>';
        }

        echo '      <tr valign="top">';
        echo '          <td><input type="text" name="scriptrules[new][scriptregex]" value="" /></td>';
        echo '          <td>';
        echo '              <select name="scriptrules[new][scripttrigger]">';
        echo '                  <option value="intersectionobserver">Scroll into view</option>';
        echo '                  <option value="hover">Hover / Click</option>';
        echo '                 <option value="idle">Load when browser is idle</option>';
        echo '                 <option value="interaction">Load on Browser Interaction</option>';
        echo '                 <option value="async">Load Async</option>';
        echo '                 <option value="defer">Load Deferred</option>';
        echo '                 <option value="block">Load render blocking</option>';
        echo '                 <option value="remove">Remove this script</option>';
        echo '             </select>';
        echo '          </td>';
        echo '         <td><input type="text" name="scriptrules[new][scriptselector]" value="" /></td>';
        echo '         <td></td>';
        echo '      </tr>';
        echo '   </table>';
        echo '</div>';
        exit();
    }



    /* delete all critical css rules*/
    public static function wp_cwv_delete_script_rule()
    {
        $oCriticalRules = ScriptRulesDB::delete($_POST['id']);
    }
}
