<?php 

namespace WPCWV;


if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}

class cwv_options
{
	private static $defaults = [


		/* CSS */
		'wp_cwv_css' => 0,
		'cwv_combine_css' => 1,
		'cwv_combine_inline_css' => 1,
		'compress_css' => 0,

		/* IMAGES */
		'cwv_lazy_load_images' => 1,
		'cwv_lazy_load_bg_images' => 0,
		'cwv_async_render_images' => 1,
		'cwv_img_width_height' => 1,

		/*scripts */
		'cwv_defer_scripts' => 1,
		'cwv_footer_scripts' => 1,
		'cwv_optimize_script_events' => 1,

		/* cache */
		'wp_cwv_page_cache' => 1,
		'wp_cwv_cache_ttl_hours' => 744,
		'wp_cwv_page_cache_urlparam' => 0,
		'cwv_page_minify' => 1,

		/* resource hint removal */
		'cwv_page_remove_dns_prefetch' => 1,
		'cwv_page_remove_preconnect' => 1,
		'cwv_page_remove_prefetch' => 0,
		'cwv_page_remove_preload' => 0,
		
		/* page options */
		'cwv_footer_content_visibility'=>0,
		'cwv_lazy_load_iframes'=>1,
		'cwv_lazy_load_iframes_js'=>0,
		'cwv_prefetch_links'=>0,
		'cwv_prefetch_prio'=>1,

		/* fonts */
		'cwv_text_rendering' => 1,
		'cwv_remove_google_fonts'=>0,
		'cwv_lazy_load_icons'=>1,

		/* beta */
		'cwv_show_beta_features'=>0,
		'cwv_use_advanced_cache'=>0,

		/* ele,mentor */
		'elementor_skip_post_css'=>0,
		'elementor_inline_post_css'=>0,
	];

	private static $options = [];

	public static function __constructStatic()
	{
		self::$options = json_decode(get_option('wp_cwv_options'), true);
	}


	public static function get($key)
	{
		if (isset(self::$options[$key])) {
			return self::$options[$key];
		} else if (isset(self::$defaults[$key])) {
			return self::$defaults[$key];
		}

		return false;
	}
}
