<?php

namespace WPCWV;


if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}

class cwv_notice
{

    private static $b = false;

    /**
     * Initializes the class
     *
     * @return void
     */
    public static function init()
    {
        // promo_notice ???
        add_action('admin_notices',  'WPCWV\cwv_notice::promo');
        add_action('wp_ajax_cwv_dismiss_notice', 'WPCWV\cwv_notice::dismiss_notice');
    }


    public static function load_styles_and_scripts()
    {

        if (self::$b === true) {
            return;
        }

        self::$b = true;

        wp_register_style('wp_cwv_plugin_notice_admin_style', WP_CWV_PLUGIN_DIR . 'admin/css/notice.css', [], WP_CWV_VERSION);
        wp_enqueue_style('wp_cwv_plugin_notice_admin_style');


        wp_register_script('wp_cwv_plugin_notice_admin_script', WP_CWV_PLUGIN_DIR . 'admin/js/notice.js', array('jquery'), WP_CWV_VERSION, true);
        wp_enqueue_script('wp_cwv_plugin_notice_admin_script');
    }

    public static function dismiss_notice()
    {
        $id = preg_replace('/[^a-z]/', '', $_POST['id']);

        //set_transient('cwv_' . $id, json_encode(['dismissed' => true]), 60 * 60 * 24 * 7);
        set_transient('cwv_' . $id, json_encode(['dismissed' => true]), 60 * 60 * 24 * 7);

        wp_send_json_success();
    }

    /**
     * Show a test notification
     *
     * @return void
     */
    public static function promo()
    {


        $bCanShowPromoNotice = self::canShowPromoNotice();


        if (!$bCanShowPromoNotice) {
            return;
        }

        // wp-corewebvitals.json is the file with the actual plugin information on your server

        $mData = get_transient('cwv_promo');

        // transient not set, let's get the remote file and set the transient
        if ($mData === false) {
            $remote = wp_remote_get(
                'https://www.corewebvitals.io/plugin/wp-corewebvitals_promo.json?cb=' . microtime(true) . '&license_key=' . urlencode(cwv_options::get('cwv_api_key')),
                array(
                    'timeout' => 10,
                    'headers' => array(
                        'Accept' => 'application/json'
                    )
                )
            );

            if (!is_wp_error($remote) && isset($remote['response']['code']) && $remote['response']['code'] == 200 && !empty($remote['body'])) {
                set_transient('cwv_promo', $remote['body'], 60 * 60 * 24 * 7);
            }

            $mData = $remote['body'];
        }


        $json = json_decode($mData, true);
        if ($json['dismissed'] === true) {
            return;
        }

        $html = '<div class="cwv_notice_grid">
        <img width="140" height="30" src="' . WP_CWV_PLUGIN_DIR . '/admin/img/cwv_logo_plugin.png">
        ' . $json['html'] . '
        <p>Rev up your website\'s performance with our Pagespeed course - faster sites, happier users!</p>
        <a class="button button-primary" href="https://www.corewebvitals.io/pagespeed-course" target="_blank">Learn More</a>
        </div>';
        self::cwv_notice(
            [
                'class'      => 'cwv_ad',
                'dismissible' => true,
                'html'     => $html,
                'id'     => 'promo',
            ]
        );
    }


    /**
     * Checks if we can show the notice
     *
     * @return boolean
     */
    private static function canShowPromoNotice()
    {
        $ts = get_option('wp_cwv_install_ts');
        if ($ts === false) {
            add_option('wp_cwv_install_ts', time());
            return false;
        }

        if ((time() - $ts) > WP_CWV_MSG_DELAY) {
            return true;
        }

        return false;
    }


    /**
     * Displays a notice on the admin screen
     *
     * @param array $args
     * @return void
     */

    public static function cwv_notice($args)
    {

        if (wp_doing_ajax()) {
            return;
        }

        self::load_styles_and_scripts();


        $defaults = [
            'class'           => 'success',
            'dismissible'     => false,
            'message'         => false,
            'html'            => false,
        ];

        $args = wp_parse_args($args, $defaults);

        // if id not set in $args create it from the html
        if (!isset($args['id'])) {
            $args['id'] = md5($args['html']);
        }

        // if the notice has been dismissed, don't show it
        $id = preg_replace('/[^a-z]/', '', $args['id']);
        if (true === $args['dismissible'] && get_transient('cwv_' . $id)) {
            return;
        }

      
        $dismissible_html = ($args['dismissible']) ? 'is-dismissible' : '';

        if ($args['message']) {
            $args['html'] = '<p>' . $args['message'] . '</p>';
        }


        echo '<div data-id="' . esc_attr($args['id']) . '" class="cwv-notice notice notice-' . esc_attr($args['class']) . ' ' . $dismissible_html . '">';
        echo $args['html'];
        echo '</div>';
    }
}
