<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}

class FileSystem
{

    // all accceptable folders
    private static $folders = [
        'cachedir' => WP_CONTENT_DIR . '/cache/',
    ];

    // all accceptable files
    private static $files = [
        'wp-config' => ABSPATH . 'wp-config.php',
        'advanced-cache' => WP_CONTENT_DIR . '/advanced-cache.php',
    ];




    private static function getFilePath($ref)
    {
        // First, check if the file reference is in accepted files
        if (!isset(self::$files[$ref])) {
            return false;
        }

        // If it is, return the file path
        return self::$files[$ref];
    }


    private static function getFolderPath($ref)
    {
        // First, check if the folder reference is in accepted folder
        if (!isset(self::$folders[$ref])) {
            return false;
        }

        // If it is, return the folder path
        return self::$folders[$ref];
    }


    public static function file_is_writable($ref)
    {
        $file = self::getFilePath($ref);

        if ($file === false) {
            return false;
        }

        // check if file exists and is writable
        if (file_exists($file)) {
            return is_writable($file);
        }

        // check if parent directory is writable
        $dir = dirname($file);
        return is_writable($dir);

    }


    public static function file_get_contents($ref)
    {
        $file = self::getFilePath($ref);

        if ($file === false) {
            return false;
        }

        return file_get_contents($file);
    }


    public static function file_put_contents($ref, $data)
    {
        $file = self::getFilePath($ref);

        if ($file === false) {
            return false;
        }

        return file_put_contents($file, $data);
    }


    /**
     * Check if a reference directory tis writable.
     *
     * @param string $ref
     *   The ref to check.
     *
     * @return bool
     *   TRUE if the directory is writable, FALSE otherwise.
     */
    public static function dir_is_writable($ref)
    {
        // Get the path to the folder.
        $folderpath = self::getFolderPath($ref);

        // If we have no path, then we can't check it.
        if ($folderpath === false) {
            return false;
        }

        // Check if the folder is writable.
        return is_writable($folderpath);
    }
}
