<?php

class directCache
{

    private $sCacheDir = WP_CONTENT_DIR . '/cache/wp_cwv/';
    private $config = [];
    private $query = [];

    public function __construct()
    {

        $_SERVER['CWV_REQUEST_URI'] = $_SERVER['REQUEST_URI'];
        $this->checkConfig();
        $this->stripTrackingQueryString();
        $this->checkCache();
    }

    private function stripTrackingQueryString()
    {

        $urlParts = parse_url($_SERVER['CWV_REQUEST_URI']);

        // explode  wp_cwv_cache_ignore_qs by , and add to array
        $ignoreQs = explode(',', $this->config['wp_cwv_cache_ignore_qs']);
        array_push($ignoreQs, 'fbclid', '_hsmi', '_hsenc', 'gclid');

        if (isset($urlParts['query'])) {
            parse_str($urlParts['query'], $this->query);
            foreach ($this->query as $key => $value) {
                if (strpos($key, 'utm_') === 0) {
                    unset($this->query[$key]);
                } else if (in_array($key, $ignoreQs)) {
                    unset($this->query[$key]);
                }
            }
            $newQuery = http_build_query($this->query);
            $_SERVER['CWV_REQUEST_URI'] = $urlParts['path'] . ($newQuery ? '?' . $newQuery : '');
        }
    }



    private function checkConfig()
    {
        if (@file_exists($this->sCacheDir . 'config.json')) {
            $cfg = json_decode(file_get_contents($this->sCacheDir . 'config.json'), true);
            if (
                is_bool($cfg['wp_cwv_page_cache']) &&
                is_bool($cfg['wp_cwv_page_cache_urlparam']) &&
                is_bool($cfg['wp_cwv_critcal_css_only_new']) &&
                is_bool($cfg['wp_cwv_css']) &&
                is_string($cfg['wp_cwv_cache_ignore_qs']) &&

                sizeof($cfg) == 5
            ) {
                $this->config = $cfg;
            }
        }
    }


   


    private function checkCache()
    {


        // check if the request is a preload request, in that case set an expires header 30 secs into the future!
        if (function_exists('getallheaders')) {
            $aHeaders = getallheaders();
        } else {
            $aHeaders = [];

            foreach ($_SERVER as $name => $value) {
                if (substr($name, 0, 5) == 'HTTP_') {
                    $aHeaders[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))))] = $value;
                }
            }
        }

        if (isset($aHeaders['purpose']) && $aHeaders['purpose'] == 'prefetch') {
            header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 30) . ' GMT');
        }

        if (isset($aHeaders['X-Moz']) && $aHeaders['X-Moz'] == 'prefetch') {
            header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 30) . ' GMT');
        }


        //logged in
        foreach ((array)$_COOKIE as $cookie_key => $cookie_value) {
            if (preg_match("/wordpress_logged_in/i", $cookie_key)) {
                return true;
            }
        }

        // no cache system
        if ($this->config['wp_cwv_page_cache'] == false) {
            return true;
        }

        // Only GET withour vars
        if ($_SERVER['REQUEST_METHOD'] != 'GET') {
            return true;
        } else  if (is_array($this->query) && sizeof($this->query) > 0) {
            if ($this->config['wp_cwv_page_cache_urlparam'] == 0) {
                return true;
            }
        }


        // WP-CLI
        if (defined('WP_CLI') && WP_CLI) {
            return true;
        }

        // Other CLI
        // if (isset($_SERVER['argv']) && is_array($_SERVER['argv']) && sizeof($_SERVER['argv']) > 0) {
        //     echo '<!-- cwv cache disabled because of cli -->';
        //     return true;
        // }


        // if url matches wp-admin
        if (preg_match("/wp-admin/i", $_SERVER['CWV_REQUEST_URI'])) {
            return true;
        }




        $filename = md5(trim($_SERVER['HTTP_HOST']) . trim($_SERVER['CWV_REQUEST_URI'], '/')) . '.html';

        if (file_exists(WP_CONTENT_DIR . '/cache/wp_cwv/html/' . $filename . '-link')) {
            $link = file_get_contents(WP_CONTENT_DIR . '/cache/wp_cwv/html/' . $filename . '-link');
            header('Link: ' . $link);
        }

        if (file_exists(WP_CONTENT_DIR . '/cache/wp_cwv/html/' . $filename)) {
            header('X-CWV-Cache: HIT');


            readfile(WP_CONTENT_DIR . '/cache/wp_cwv/html/' . $filename);
            echo "\n<!-- cached (advanced-cache) and optimized by wp-core-web-vitals plugin @ www.corewebvitals.io -->";
            exit();
        }
    }
}

new directCache();
