<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}


class debug
{
    private static $debugdata = [];

    public static function __constructStatic()
    {
        if (WP_CWV_DEBUG) {

            self::clearDebugLog();
        }
    }

    public static function init()
    {
        add_action('wp_ajax_cwv_debug_url', 'WPCWV\debug::debug_url');
    }


    public static function debug_url()
    {

        $cookies = [];
        $cookies[] = new \WP_Http_Cookie(array(
            'name'  => 'dbg',
            'value' => '1',
        ));

        $args = [
            'cookies' => $cookies,
        ];
        
        $cwv_auth_username = cwv_options::get('cwv_auth_username');
		$cwv_auth_password = cwv_options::get('cwv_auth_password');
		
		if($cwv_auth_password && $cwv_auth_username){
            $args['headers']['Authorization'] =   'Basic ' . base64_encode( $cwv_auth_username.':'.$cwv_auth_password );
		}
        
        wp_remote_get($_POST['url'], $args);

        $res = file_get_contents(WP_CONTENT_DIR . '/cache/wp_cwv/debug.txt');
        // return json
        echo json_encode(['res' => $res]);
        wp_die();
    }


    public static function getDebugData()
    {
        return self::$debugdata;
    }

    public static function clearDebugLog()
    {
        if (WP_CWV_DEBUG) {
            file_put_contents(WP_CONTENT_DIR . '/cache/wp_cwv/debug.txt', '');
        }
    }

    /**
     * save debug log for later, if debug is enabled
     * depth is used to indent the log
     * @param $str
     * @param int $depth
     * @return void
     */
    public static function debug($str, $depth = 1)
    {
        if (WP_CWV_DEBUG) {
            // printed to html source later on.
            self::$debugdata[] = ['str' => $str, 'depth' => $depth];

            // online line at a time so we know where it went, even in case of fatal error
            file_put_contents(WP_CONTENT_DIR . '/cache/wp_cwv/debug.txt', str_repeat('---', ($depth - 1)) . ' ' . $str . PHP_EOL, FILE_APPEND);
        }
    }
}
