<?php


namespace WPCWV;

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}


class PreloadDB
{


    public static function createTable()
    {

        global $wpdb;
        $table_name_wp_cwv_rules = $wpdb->prefix . 'cwv_preload';

        $sql = "CREATE TABLE $table_name_wp_cwv_rules ( 
			`id` INT NOT NULL AUTO_INCREMENT ,
			`preloadlink` varchar(255) NOT NULL,
            `preloadtype` ENUM('preconnect', 'prefetch','preload','dns-prefetch') DEFAULT 'preload',
            `preloadfiletype` ENUM('audio', 'document','embed','fetch','font','image','script','style','video','worker') DEFAULT 'font',
			`preloadloacation`  ENUM('head', 'header') DEFAULT 'head',
			PRIMARY KEY (id)
		);";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }


    public static function findAll()
    {
        global $wpdb;
        $rows = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'cwv_preload');
        return (is_array($rows)) ? $rows : [];
    }



    public static function insert($data)
    {
        global $wpdb;
        $table = $wpdb->prefix . 'cwv_preload';
        $format = ['%s', '%s', '%s', '%s'];
        $datatoinsert = [
            'preloadlink' => $data['preloadlink'],
            'preloadtype' => $data['preloadtype'],
            'preloadfiletype' => $data['preloadfiletype'],
            'preloadloacation' => $data['preloadloacation']
        ];
        return  $wpdb->insert($table, $datatoinsert, $format);
    }

    public static function delete($id)
    {
        global $wpdb;
        $table = $wpdb->prefix . 'cwv_preload';
        return  $wpdb->delete($table, ['id' => (int)$id]);
    }

    public static function update($data, $id)
    {
        global $wpdb;
        $table = $wpdb->prefix . 'cwv_preload';
        $datatoinsert = [
            'preloadlink' => $data['preloadlink'],
            'preloadtype' => $data['preloadtype'],
            'preloadfiletype' => $data['preloadfiletype'],
            'preloadloacation' => $data['preloadloacation']
        ];
        return  $wpdb->update($table, $datatoinsert, ['id' => (int)$id]);
    }
}
