<?php

namespace WPCWV;


if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}

class CriticalRulesDB
{


    public static function createTable()
    {

        global $wpdb;
        $table_name_wp_cwv_rules = $wpdb->prefix . 'cwv_criticalrules';

        $sql = "CREATE TABLE $table_name_wp_cwv_rules ( 
                id INT NOT NULL AUTO_INCREMENT ,
                rule varchar(255) NOT NULL,
                PRIMARY KEY (id)
            );";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }


 

    public static function findAll()
    {
        global $wpdb;
        $rows = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'cwv_criticalrules');
        return (is_array($rows)) ? $rows : [];
    }



    public static function insert($data)
    {
        global $wpdb;
        $table = $wpdb->prefix . 'cwv_criticalrules';
        $format = ['%s'];
        return  $wpdb->insert($table, ['rule' => $data['rule']], $format);
    }

    public static function delete($id)
    {
        global $wpdb;
        $table = $wpdb->prefix . 'cwv_criticalrules';
        return  $wpdb->delete($table, ['id' => (int)$id]);
    }

    public static function update($data, $id)
    {
        global $wpdb;
        $table = $wpdb->prefix . 'cwv_criticalrules';
        return  $wpdb->update($table, ['rule' => $data['rule']], ['id' => (int)$id]);
    }
}
