<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}

/* This is just all queries on one page for quick access, no abstration or anything :-) */

class CriticalFilesDB
{

    public static function createTable()
    {
        global $wpdb;
        $table_name_wp_cwv_files = $wpdb->prefix . 'cwv_criticalfiles';

        $sql = "CREATE TABLE $table_name_wp_cwv_files (
			id mediumint(9) NOT NULL AUTO_INCREMENT,
			url varchar(255) NOT NULL,
			hash varchar(255) NOT NULL,
			pagetype varchar(255) NOT NULL,
			templateslug varchar(255) DEFAULT '' NOT NULL,
			posttype varchar(255) DEFAULT '' NOT NULL,
			status varchar(255) DEFAULT '' NOT NULL,
			PRIMARY KEY  (id)
		);";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }

    

    public static function getCount()
    {
        global $wpdb;
        $c = $wpdb->get_var('SELECT COUNT(*) FROM ' . $wpdb->prefix . 'cwv_criticalfiles');
        return (int)$c;
    }


    public static function findOne($data, $key)
    {
        global $wpdb;
        return $wpdb->get_row('SELECT id FROM ' . $wpdb->prefix . 'cwv_criticalfiles WHERE hash="' . $data[$key] . '"');
    }


    public static function findAll()
    {
        global $wpdb;
        $rows = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'cwv_criticalfiles');
        return (is_array($rows)) ? $rows : [];
    }



    public static function insert($data)
    {
        global $wpdb;
        $table = $wpdb->prefix . 'cwv_criticalfiles';
        $format = ['%s', '%s', '%s', '%s', '%s', '%s'];
        return  $wpdb->insert($table, $data, $format);
    }
}
