<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}


function wpcwv_autoload($className)
{


    $aClassMap = array(

        /* core */
        'WPCWV\CWV'                         => 'optim/main.php',
        'WPCWV\StrategyInterface'           => 'optim/common/StrategyInterface.php',
        'WPCWV\CssUtilities'                => 'optim/common/CssUtilities.php',
        'WPCWV\CWVCache'                    => 'optim/cache/CWVCache.php',
        'WPCWV\StyleRewriteBase'            => 'optim/css/StyleRewriteBase.php',
        'WPCWV\StyleRewriteStrategy'        => 'optim/css/StyleRewriteStrategy.php',
        'WPCWV\StyleAddDOMStrategy'         => 'optim/css/StyleAddDOMStrategy.php',
        'WPCWV\ScriptDeferStrategy'         => 'optim/js/ScriptDeferStrategy.php',
        'WPCWV\ImgStrategy'                 => 'optim/img/ImgStrategy.php',
        'WPCWV\IframeStrategy'              => 'optim/iframe/IframeStrategy.php',
        'WPCWV\HtmlStrategy'                => 'optim/html/HtmlStrategy.php',
        'WPCWV\ResourceHintsStrategy'       => 'optim/html/ResourceHintsStrategy.php',
        'WPCWV\FontStrategy'                => 'optim/font/FontStrategy.php',

        /* third pary */
        'WPCWV\Minify_CSS'                  => 'optim/common/3p/cssmin.php',
        'WPCWV\Minify_HTML'                 => 'optim/common/3p/htmlmin.php',

        /* helpers */
        'WPCWV\HtmlHelper'                  => 'optim/common/HtmlHelper.php',
        'WPCWV\cwvh'                        => 'optim/common/CWVHelper.php',
        'WPCWV\TagStorage'                  => 'optim/common/TagStorage.php',
        
        /* lib */
        'WPCWV\FileSystem'                  => 'lib/filesystem.php',
        'WPCWV\cwv_options'                 => 'lib/options.php',
        'WPCWV\cwv_cache'                   => 'lib/cache.php',
        'WPCWV\cwv_advanced_cache'          => 'lib/advanced_cache.php',
        
        'WPCWV\cwv_script_rules'            => 'lib/script_rules.php',
        'WPCWV\cwv_preloads'                => 'lib/preloads.php',

        'WPCWV\CriticalRulesDB'             => 'lib/db_critical_rules.php',
        'WPCWV\CriticalFilesDB'             => 'lib/db_critical_files.php',
        'WPCWV\ScriptRulesDB'               => 'lib/db_script_rules.php',
        'WPCWV\PreloadDB'                   => 'lib/db_preload.php',
      
        'WPCWV\cwv_notice'                  => 'lib/notice.php',
        'WPCWV\debug'                       => 'lib/debug.php',

        /* admin */
        'WPCWV\cwv_admin_settings'          => 'admin/settings.php',
        'WPCWV\cwv_admin_install'           => 'admin/install.php',


    );

    if (isset($aClassMap[$className])) {
        require_once(WP_CWV_PLUGIN_PATH . $aClassMap[$className]);

        // static constructor
        if (method_exists($className, '__constructStatic')) {
            $className::__constructStatic();
        }
    }
}


spl_autoload_register('WPCWV\wpcwv_autoload');
