<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}

class cwv_advanced_cache
{

    public static $advancedCacheCode = '<?php 
    /* auto generated by wp-core-web-vitals, do not remove*/
    define(\'CWV_ADVANCED_CACHE_PASSED\', true);

    if(@file_exists( WP_CONTENT_DIR.\'/plugins/wp-core-web-vitals/lib/directcache.php\')){
        require_once WP_CONTENT_DIR.\'/plugins/wp-core-web-vitals/lib/directcache.php\';
    }';

    public static function init()
    {
        if (is_admin()) {
            add_action('admin_init', 'WPCWV\cwv_advanced_cache::check_settings');
        }
    }


    public static function check_settings()
    {

        if (cwv_options::get('cwv_use_advanced_cache') && cwv_options::get('cwv_use_advanced_cache') == 1) {

            if (defined('WP_CACHE') && WP_CACHE == true) {
                // yeah!!
            } else {
                // probably cant write to file! Let them try it !
                cwv_notice::cwv_notice(
                    [
                        'class' => 'warning',
                        'id' => 'missing_WP_CACHE',
                        'message' => 'Advanced cache is enabled but not active. Please add the variable <code>define(\'WP_CACHE\', true);</code> to your wp-config.php file.'
                    ]
                );
            }


            if (defined('WP_CACHE') && WP_CACHE == true) {
                // yeah!!
            } else {
                // probably cant write to file! Let them try it !
                cwv_notice::cwv_notice(
                    [
                        'class' => 'warning',
                        'id' => 'missing_CWV_ADVANCED_CACHE_PASSED',
                        'message' => 'Advanced cache is enabled but not active. Change the file wp-content/advanced-cache-php and add this code to it <br /><code>' . nl2br(htmlentities(self::$advancedCacheCode)) . '</code>'
                    ]
                );
            }
        }
    }

    public static function write_config($bool)
    {

        // bool to text;
        $configval = (true === $bool)?'true':'false';

        // use cachcode or empty string;
        $cachecode = (true === $bool)?self::$advancedCacheCode:'';


        if (true === FileSystem::file_is_writable('wp-config')) {

            // Read the contents of the wp-config.php file
            $config_contents = FileSystem::file_get_contents('wp-config');

            // Check if WP_CACHE is already defined
            if (preg_match('/define\(\s*\'WP_CACHE\'/', $config_contents)) {
                // WP_CACHE is already defined, so update its value
                $new_config_contents = preg_replace('/define\(\s*\'WP_CACHE\'.*?\);/', "define('WP_CACHE', ".$configval.");", $config_contents);
            } else {
                // WP_CACHE is not defined, so add it to the file
                $new_config_contents = str_replace("\$table_prefix", "define('WP_CACHE', ".$configval.");\n\$table_prefix", $config_contents);
            }

            // Write the updated contents back to the wp-config.php file
            FileSystem::file_put_contents('wp-config', $new_config_contents);
        }

        if (true === FileSystem::file_is_writable('advanced-cache')) {
            // Write the updated contents back to the advanced-cache file
            FileSystem::file_put_contents('advanced-cache', $cachecode);
        }
    }
}
