<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
  die('Let\'s not do this');
}

/**
 * WP Core Web Vitals Settings class, self contains the settings page and admin menu
 * - admin menu
 * - admin scripts
 * - admin styles
 * - admin toolbar
 **/
class cwv_admin_settings
{
  public static function init()
  {
    self::scripts();
    self::adminmenu();
    self::check_is_writable();

    // save options
    add_action('admin_init', 'WPCWV\cwv_admin_settings::checkincompatibleplugins');

    add_action('wp_ajax_wpcwv_save_options', 'WPCWV\cwv_admin_settings::save_options');
  }

  /**
   * Check is cache folder is writable or send a warning to the backend!
   */
  public static function check_is_writable()
  {
    if (is_writable(WP_CONTENT_DIR . '/cache/') === false) {
      add_action('admin_notices', function () {
        echo '
        <div class="notice notice-warning  is-dismissible">
          <p><strong>WP Core Web Vitals Warning</strong></p>
          <p>You cache folder (' . WP_CONTENT_DIR . '/cache/)is not writable. Please consult the WordPress <a href="https://wordpress.org/support/article/changing-file-permissions/">documentation</a>
        </div>';
      });
    }
  }


  public static function checkincompatibleplugins()
  {

    $aCachingPlugins = [
      'wp-fastest-cache/wpFastestCache.php',
      'wp-super-cache/wp-cache.php',
      'wp-rocket/wp-rocket.php',
      'comet-cache/comet-cache.php',
      'hyper-cache/plugin.php',
      'cache-enabler/cache-enabler.php',
      'cachify/cachify.php',
      'litespeed-cache/litespeed-cache.php'
    ];



    foreach ($aCachingPlugins as $sPlugin) {
      // extract name from $sPlugin

      if (is_plugin_active($sPlugin)) {
        $sPluginName = str_replace('-', ' ', explode('/', $sPlugin)[0]);

        cwv_notice::cwv_notice(
          [
            'class'           => 'warning',
            'html'            => '
            <p><strong>WP Core Web Vitals Warning</strong></p>
            <p>You have enabled the ' . $sPluginName . ' caching plugin. 
            WP Core Web Vitals has it\'s own caching system. Multiple layers of caching 
            will not speed up your site and will lead to unpredictable results.
            Disable ' . $sPluginName . ' to take full advantage of WP Core Web Vitals. </p>
          ',
          ]
        );
      }
    }
  }



  /**
   * Add admin menu
   * @return void
   */
  private static function adminmenu()
  {

    add_action('admin_bar_menu', 'WPCWV\cwv_admin_settings::cwv_toolbar', 100);
    add_action('admin_menu', 'WPCWV\cwv_admin_settings::wp_cwv_create_menu');
  }

  private static function scripts()
  {
    add_action('admin_enqueue_scripts', 'WPCWV\cwv_admin_settings::wp_cwv_admin_scripts_styles');
  }


  public static function wp_cwv_admin_scripts_styles($hook)
  {

    if ($hook != 'settings_page_wp_core_web_vitals') {
      return;
    }
    wp_register_script('wp_cwv_plugin_settings_admin_script', WP_CWV_PLUGIN_DIR . 'admin/js/settings.js', array('jquery'), WP_CWV_VERSION, true);
    wp_enqueue_script('wp_cwv_plugin_settings_admin_script');

    
  }

  /**
   * Create entry in options menu
   */
  public static function wp_cwv_create_menu()
  {
    add_options_page('WP Core Web Vitals', 'WP Core Web Vitals', 'manage_options', 'wp_core_web_vitals', 'WPCWV\cwv_admin_settings::wp_core_web_vitals_options_content', 0);
  }

  /**
   * Settings page
   */
  public static function wp_core_web_vitals_options_content()
  {

    if (function_exists('getallheaders')) {
      $aHeaders = getallheaders();
    } else {
      $aHeaders = [];

      foreach ($_SERVER as $name => $value) {
        if (substr($name, 0, 5) == 'HTTP_') {
          $aHeaders[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))))] = $value;
        }
      }
    }

    $bIsCloudFlare = isset($aHeaders['Cf-Ray']) ? true : false;

    include(WP_CWV_PLUGIN_PATH . 'admin/html/settings.php');
  }

  /**
   * Add toolbar menu
   */
  public static function cwv_toolbar($admin_bar)
  {
    $admin_bar->add_menu(array(
      'id'    => 'wp_cwv_plugin',
      'title' => 'WP Core Web Vitals',
      'href'  => '#'
    ));

    $admin_bar->add_menu(array(
      'id'    => 'wp_cwv_plugin_settings',
      'parent' => 'wp_cwv_plugin',
      'title' => 'Settings',
      'href'  => get_admin_url() . 'options-general.php?page=wp_core_web_vitals'
    ));

    $admin_bar->add_menu(array(
      'meta' => [
        'onclick' => 'var c1t = this; this.style.color = "#0a0a0a";jQuery.post("' . esc_url(admin_url('admin-ajax.php')) . '", {"action":"critical_clear_cache"},function(){c1t.style.color = "green"});return false;',
      ],
      'id'    => 'critical_clear_cache',
      'parent' => 'wp_cwv_plugin',
      'title' => 'Clear cache',
      'href'  => get_admin_url() . 'options-general.php?page=corewebvitals&cwv_cc=true'
    ));


    $admin_bar->add_menu(array(
      'parent' => 'wp_cwv_plugin',
      'title' => 'Help',
      'id' => 'wp_cwv_plugin_documentation',
    ));

    $admin_bar->add_menu(array(
      'id' => 'cwv_plugin_doc_link',
      'parent' => 'wp_cwv_plugin_documentation',
      'title' => 'Documentation',
      'href'  => 'https://www.corewebvitals.io/wp-core-web-vitals/installation'
    ));

    $admin_bar->add_menu(array(
      'id' => 'cwv_plugin_troubleshoot_link',

      'parent' => 'wp_cwv_plugin_documentation',
      'title' => 'Troubleshooting',
      'href'  => 'https://www.corewebvitals.io/wp-core-web-vitals/troubleshooting'
    ));
  }



  public static function save_options()
  {


    $sCacheDir = WP_CONTENT_DIR . '/cache/wp_cwv/';

    // save minimal cache config to file for direct caching
    if (is_writeable($sCacheDir)) {
      $configdata = [
        'wp_cwv_page_cache' => boolval($_POST['wp_cwv_page_cache']),
        'wp_cwv_page_cache_urlparam' => boolval($_POST['wp_cwv_page_cache_urlparam']),
        'wp_cwv_critcal_css_only_new' => boolval($_POST['wp_cwv_critcal_css_only_new']),
        'wp_cwv_css' => boolval($_POST['wp_cwv_css']),
        'wp_cwv_cache_ignore_qs' => strval($_POST['wp_cwv_cache_ignore_qs']),
      ];

      file_put_contents($sCacheDir . 'config.json', json_encode($configdata));
    }



    $validate = wp_verify_nonce($_POST['cwv_nonce'], 'cwv_nonce');
    if (false == $validate || !current_user_can('manage_options')) {
      die('Mr. Ranger\'s not gonna like this, Yogi...');
    }


    foreach ($_POST['scriptrules'] as $k => $v) {
      if ($k == 'new' && strlen($v['scriptregex']) > 0) {
        ScriptRulesDB::insert(['scriptregex' => $v['scriptregex'], 'scripttrigger' => $v['scripttrigger'], 'scriptselector' => $v['scriptselector']]);
      } else if (strlen($v['scriptregex']) > 0) {
        ScriptRulesDB::update(['scriptregex' => $v['scriptregex'], 'scripttrigger' => $v['scripttrigger'], 'scriptselector' => $v['scriptselector']], $k);
      }
    }


    foreach ($_POST['preloads'] as $k => $v) {
      if ($k == 'new' && strlen($v['preloadlink']) > 0) {
        PreloadDB::insert(['preloadlink' => $v['preloadlink'], 'preloadtype' => $v['preloadtype'], 'preloadfiletype' => $v['preloadfiletype'], 'preloadloacation' => $v['preloadloacation']]);
      } else if (strlen($v['preloadlink']) > 0) {
        PreloadDB::update(['preloadlink' => $v['preloadlink'], 'preloadtype' => $v['preloadtype'], 'preloadfiletype' => $v['preloadfiletype'], 'preloadloacation' => $v['preloadloacation']], $k);
      }
    }

    if ((bool) cwv_options::get('cwv_use_advanced_cache') != (bool)$_POST['cwv_use_advanced_cache']) {
      cwv_advanced_cache::write_config((bool)$_POST['cwv_use_advanced_cache']);
    }



    unset($_POST['cwv_nonce']);
    unset($_POST['rules']);
    unset($_POST['scriptrules']);
    unset($_POST['cwv_debug_url']);
    unset($_POST['preloads']);

    //add_option('wp_cwv_options',json_encode($_POST));
    update_option('wp_cwv_options', json_encode($_POST));
    die('just saving da options asd');
  }
}
