<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
	die('Let\'s not do this');
}


/**
 * Install The Core Web Vitals plugin class
 * - install hook
 * - check for updates
 * - add cron job
 */
class cwv_admin_install
{
	public static function init()
	{

		// install hook (dont need this do we?)
		register_activation_hook(__FILE__, 'WPCWV\cwv_admin_install::wp_cwv_install');

		// check for db updates / install
		cwv_admin_install::wp_cwv_install();

		add_action('admin_init', 'WPCWV\cwv_admin_install::catch_deactivate');

		// add cron job
		add_action('wp_cwv_hourly_cron', 'WPCWV\cwv_admin_install::wp_cwv_hourly_cron');
	}


	public static function catch_deactivate(){

        //wp_register_script('wp_cwv_plugin_deactivate_admin_script', WP_CWV_PLUGIN_DIR . 'admin/js/deactivate.js', array('jquery'), WP_CWV_VERSION, true);
		//wp_enqueue_script('wp_cwv_plugin_deactivate_admin_script');

	}


	/**
	 * Install WP Core Web Vitals
	 * - create tables
	 * - add cron
	 * @return void
	 */
	public static function wp_cwv_install()
	{
		$wp_cwv_db_version = get_option("wp_cwv_db_version");

		if ($wp_cwv_db_version != WP_CWV_VERSION) {

			// update database version
			update_option("wp_cwv_db_version", WP_CWV_VERSION);

			// tables
			ScriptRulesDB::createTable();
			PreloadDB::createTable();

			// cron
			wp_clear_scheduled_hook('wp_cwv_hourly_cron');
			if (!wp_next_scheduled('wp_cwv_hourly_cron')) {
				wp_schedule_event(time(), 'hourly', 'wp_cwv_hourly_cron');
			}
		}
	}



	/**
	 * Hourly CRON
	 * @return void
	 */
	public static function wp_cwv_hourly_cron()
	{
		// delete outdated html cache
		cwv_cache::deleteOutDatedCache();
	}
}


/** LEAVE THIS LIKE THIS FOR NOW! **/

/* CUSTOM UPDATES */
add_filter('plugins_api', 'WPCWV\cwv_plugin_info', 20, 3);

function cwv_plugin_info($res, $action, $args)
{


	// do nothing if this is not about getting plugin information
	if ('plugin_information' !== $action) {
		return false;
	}

	$plugin_slug = 'wp-core-web-vitals'; // we are going to use it in many places in this function

	// do nothing if it is not our plugin
	if ($plugin_slug !== $args->slug) {
		return false;
	}


	// trying to get from cache first
	$remote = get_transient('cwv_plugin_remote_cache');

	if ($remote === false) {
		// wp-corewebvitals.json is the file with the actual plugin information on your server
		$remote = wp_remote_get(
			add_query_arg(
				[
					'from' => 'cwv_plugin_info',
					'v' => WP_CWV_VERSION,
					'license_key' => urlencode(cwv_options::get('cwv_api_key')),
					'cb' => microtime(true)
				],
				'https://www.corewebvitals.io/plugin/wp-corewebvitals.json'
			),
			array(
				'timeout' => 10,
				'headers' => array(
					'Accept' => 'application/json'
				)
			)
		);


		if (
			is_wp_error($remote)
			|| 200 !== wp_remote_retrieve_response_code($remote)
			|| empty(wp_remote_retrieve_body($remote))
		) {
			return false;
		}


		set_transient('cwv_plugin_remote_cache', $remote, 60*60*1); // 1 hours cache
	}

	$remote = json_decode($remote['body']);
	$res = new \stdClass();

	$res->name = $remote->name;
	$res->slug = $plugin_slug;
	$res->version = $remote->version;
	$res->tested = $remote->tested;
	$res->requires = $remote->requires;
	$res->download_link = $remote->download_url;
	$res->trunk = $remote->download_url;
	$res->requires_php = '5.3';
	$res->last_updated = $remote->last_updated;
	$res->sections = array(
		'description' => $remote->sections->description,
		'installation' => $remote->sections->installation,
		'changelog' => $remote->sections->changelog
	);

	if (!empty($remote->sections->screenshots)) {
		$res->sections['screenshots'] = $remote->sections->screenshots;
	}

	return $res;
}



add_filter('site_transient_update_plugins', 'WPCWV\cwv_push_update');

function cwv_push_update($transient)
{

	// trying to get from cache first
	$remote = get_transient('cwv_plugin_remote_cache');




	if ($remote === false) {
		// wp-corewebvitals.json is the file with the actual plugin information on your server
		$remote = wp_remote_get(
			add_query_arg(
				[
					'from' => 'cwv_push_update',
					'v' => WP_CWV_VERSION,
					'license_key' => urlencode(cwv_options::get('cwv_api_key')),
					'cb' => microtime(true)
				],
				'https://www.corewebvitals.io/plugin/wp-corewebvitals.json'
			),
			array(
				'timeout' => 10,
				'headers' => array(
					'Accept' => 'application/json'
				)
			)
		);
		if (
			is_wp_error($remote)
			|| 200 !== wp_remote_retrieve_response_code($remote)
			|| empty(wp_remote_retrieve_body($remote))
		) {
			return false;
		}
	}



	set_transient('cwv_plugin_remote_cache', $remote, 60*60*1); // 1 hours cache

	$remote = json_decode($remote['body']);

	// your installed plugin version should be on the line below! You can obtain it dynamically of course 
	if ($remote && version_compare(WP_CWV_VERSION, $remote->version, '<')) {

		$res = new \stdClass();
		$res->slug = 'wp-core-web-vitals';
		$res->plugin = 'wp-core-web-vitals/wpcorewebvitals.php'; // it could be just YOUR_PLUGIN_SLUG.php if your plugin doesn't have its own directory
		$res->new_version = $remote->version;
		$res->tested = $remote->tested;
		$res->package = $remote->download_url;
		if (is_object($transient)) {
			$transient->response[$res->plugin] = $res;
		}
	}
	return $transient;
}
