<?php

namespace WPCWV; 

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}
?>

<div class="cwv-tab-panel" id="tabs-resourcehints" style="display: none;">

    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-resourcehint"></use>
        </svg>
        Resource Hints
        <svg data-help=".optionshelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>

    <div class="cwvhelptext optionshelp">
        <p>These options will allow you to remove or reset all the default resource hints.</p>

    </div>


    <table class="form-table" width="100%">


        <tr valign="top">
            <th scope="row">Remove dns-prefetch tags</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_page_remove_dns_prefetch" id="cwv_page_remove_dns_prefetch0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_page_remove_dns_prefetch')); ?> />
                    <label for="cwv_page_remove_dns_prefetch0">no</label>
                    <input name="cwv_page_remove_dns_prefetch" id="cwv_page_remove_dns_prefetch1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_page_remove_dns_prefetch')); ?> />
                    <label for="cwv_page_remove_dns_prefetch1">yes</label>
                </div>
                <p class="inlinehelp">Remove dns-prefetch tags from the page</p>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">Remove preconnect tags</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_page_remove_preconnect" id="cwv_page_remove_preconnect0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_page_remove_preconnect')); ?> />
                    <label for="cwv_page_remove_preconnect0">no</label>
                    <input name="cwv_page_remove_preconnect" id="cwv_page_remove_preconnect1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_page_remove_preconnect')); ?> />
                    <label for="cwv_page_remove_preconnect1">yes</label>
                </div>
                <p class="inlinehelp">Remove preconnect tags from the page</p>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">Remove prefetch tags</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_page_remove_prefetch" id="cwv_page_remove_prefetch0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_page_remove_prefetch')); ?> />
                    <label for="cwv_page_remove_prefetch0">no</label>
                    <input name="cwv_page_remove_prefetch" id="cwv_page_remove_prefetch1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_page_remove_prefetch')); ?> />
                    <label for="cwv_page_remove_prefetch1">yes</label>
                </div>
                <p class="inlinehelp">Remove prefetch tags from the page</p>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">Remove preload tags</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_page_remove_preload" id="cwv_page_remove_preload0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_page_remove_preload')); ?> />
                    <label for="cwv_page_remove_preload0">no</label>
                    <input name="cwv_page_remove_preload" id="cwv_page_remove_preload1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_page_remove_preload')); ?> />
                    <label for="cwv_page_remove_preload1">yes</label>
                </div>
                <p class="inlinehelp">Remove preload tags from the page</p>
            </td>
        </tr>




    </table>


    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-scripts"></use>
        </svg>
        Add Custom Resource Hints
        <svg data-help=".preloadshelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>
    <div class="cwvhelptext preloadshelp">
        <p>
            The custom resourse hints will help you build a better resource hint strategy.
            Use resource hints to improve the performance of your site by telling the browser to load pre connect rto certain resources before it needs them.
            But be carefull and do not overuse them!

        </p>

    </div>

    <div id="preloads">
    </div>


</div>