<?php

namespace WPCWV; 

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}
?>

<div class="cwv-tab-panel" id="tabs-page" style="display: none;">

    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-options"></use>
        </svg>
        Page options
        <svg data-help=".optionshelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>

    <div class="cwvhelptext optionshelp">
        <p>Misc page options to speed up parts of your page.</p>
        <p>Preconnect and dns-prefetch tags should only be set for critical resources like the main CDN. Removing unneeded dns prefetch and preconnect will ikely speed up your page</p>
        <p>Lazy rendering the foot er will add <code>content-visibility:auto;</code> to the footer of the page. This will delay browser rendering of the footer until just before it scrols into view. </p>
        <p>Lazy loading iFrames will only load iFrames when they are in the visible viewport.</p>

    </div>


    <table class="form-table" width="100%">


       

        <tr valign="top">
            <th scope="row">Lazy render the footer</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_footer_content_visibility" id="cwv_footer_content_visibility0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_footer_content_visibility')); ?> />
                    <label for="cwv_footer_content_visibility0">no</label>
                    <input name="cwv_footer_content_visibility" id="cwv_footer_content_visibility1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_footer_content_visibility')); ?> />
                    <label for="cwv_footer_content_visibility1">yes</label>
                </div>
                <p class="inlinehelp">Lazy render the footer by adding CSS content-visibility:auto to the footer.</p>
            </td>
        </tr>

        <tr valign="top" date-depends="cwv_footer_content_visibility">
            <th scope="row">Footer selector</th>
            <td><input type="text" placeholder="example: footer or .site-footer or #foot" name="cwv_footer_selector" value="<?php echo esc_attr(cwv_options::get('cwv_footer_selector')); ?>" />
                <p class="inlinehelp">Tell us how to identify your footer element.</p>
            </td>


        </tr>


        <tr valign="top">
            <th scope="row">Enable native iframe lazy load</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_lazy_load_iframes" id="cwv_lazy_load_iframes0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_lazy_load_iframes')); ?> />
                    <label for="cwv_lazy_load_iframes0">no</label>
                    <input name="cwv_lazy_load_iframes" id="cwv_lazy_load_iframes1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_lazy_load_iframes')); ?> />
                    <label for="cwv_lazy_load_iframes1">yes</label>
                </div>
                <p class="inlinehelp">Add native lazy loading to all iframes! </p>
            </td>
        </tr>

        <tr valign="top">
            <th scope="row">Enable JavaScript iframe lazy load</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_lazy_load_iframes_js" id="cwv_lazy_load_iframes_js0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_lazy_load_iframes_js')); ?> />
                    <label for="cwv_lazy_load_iframes_js0">no</label>
                    <input name="cwv_lazy_load_iframes_js" id="cwv_lazy_load_iframes_js1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_lazy_load_iframes_js')); ?> />
                    <label for="cwv_lazy_load_iframes_js1">yes</label>
                </div>
                <p class="inlinehelp">Add JavaScript lazy loading to all iframes! JS based lazy loading enables lazy loading on browser that <a href="https://caniuse.com/loading-lazy-attr">do not support native lazy loading</a></p>
            </td>
        </tr>


        <tr valign="top">
            <th scope="row">Prerender or Prefetch links</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_prefetch_links" id="cwv_prefetch_links0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_prefetch_links')); ?> />
                    <label for="cwv_prefetch_links0">no</label>
                    <input name="cwv_prefetch_links" id="cwv_prefetch_links1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_prefetch_links')); ?> />
                    <label for="cwv_prefetch_links1">prefetch</label>
                    <input name="cwv_prefetch_links" id="cwv_prefetch_links2" type="radio" value="2" <?php checked('2', cwv_options::get('cwv_prefetch_links')); ?> />
                    <label for="cwv_prefetch_links2">prerender</label>
                </div>
                <p class="inlinehelp">Prefetching will pre-warm the browser cache before a visitor is likely click on it. Prerendering links will render and pre-cache a page + it's resources before a visitor is likely click on it. Suggested setting: prefetch.</p>
            </td>
        </tr>

        <tr valign="top" data-depends="cwv_prefetch_links">
            <th scope="row">Prerender or Prefetch priority</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_prefetch_prio" id="cwv_prefetch_prio1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_prefetch_prio')); ?> />
                    <label for="cwv_prefetch_prio1">moderate</label>
                    <input name="cwv_prefetch_prio" id="cwv_prefetch_prio2" type="radio" value="2" <?php checked('2', cwv_options::get('cwv_prefetch_prio')); ?> />
                    <label for="cwv_prefetch_prio2">eager</label>
                    <input name="cwv_prefetch_prio" id="cwv_prefetch_prio3" type="radio" value="3" <?php checked('3', cwv_options::get('cwv_prefetch_prio')); ?> />
                    <label for="cwv_prefetch_prio3">conservative</label>
                </div>
                <p class="inlinehelp">Sets the prefertch or preload eagerness for links. Sugested setting: moderate!</p>
            </td>
        </tr>


        <tr valign="top">
            <th scope="row">Minify HTML</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_page_minify" id="cwv_page_minify0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_page_minify')); ?> />
                    <label for="cwv_page_minify0">no</label>
                    <input name="cwv_page_minify" id="cwv_page_minify1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_page_minify')); ?> />
                    <label for="cwv_page_minify1">yes</label>
                </div>
                <p class="inlinehelp">Minify HTMl will minify your HTML code. This will speed up your site but might cause issues with broken HTML.</p>
            </td>
        </tr>


    </table>




    
</div>