<?php

namespace WPCWV; 

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}
?>

<div class="cwv-tab-panel" id="tabs-js" style="display: none;">

    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-scripts"></use>
        </svg>
        Scripts - Deferred loading & basic priority
        <svg data-help=".scriptshelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>

    <div class="cwvhelptext scriptshelp">
        <p>Deferring Scripts is usually pretty safe and should probably be enabled for most sites!</p>
        <p>
            The defer script option adds <code>loading="lazy"</code> to all scripts. This changes the default behavior of the browser to load scripts deferred.
            This can improve the paint metrics (FCP and LCP). Be carefull not to defer scripts that are critical for rendering!
        </p>
        <p>
            Moving scripts to the footer of the page will change the order in which resources are schduled. This usually means the non-lazy loaded images will be given priority over scripts. Sometimes this is a good thing, sometimes it is not. So be careful!
            This can improve the paint metrics (FCP and LCP). Be carefull not to defer scripts that are critical for rendering!
        </p>
    </div>


    <table class="form-table">
        <tr valign="top">
            <th scope="row">Defer JavaScripts</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_defer_scripts" id="cwv_defer_scripts0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_defer_scripts')); ?> />
                    <label for="cwv_defer_scripts0">no</label>
                    <input name="cwv_defer_scripts" id="cwv_defer_scripts1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_defer_scripts')); ?> />
                    <label for="cwv_defer_scripts1">yes</label>
                </div>
                <p class="inlinehelp">Changes the default behavior of the browser to load scripts deferred.
                    This can improve the paint metrics (FCP and LCP). Be carefull not to defer scripts that are critical for rendering!</p>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">Move JavaScripts to bottom of the page</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_footer_scripts" id="cwv_footer_scripts0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_footer_scripts')); ?> />
                    <label for="cwv_footer_scripts0">no</label>
                    <input name="cwv_footer_scripts" id="cwv_footer_scripts1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_footer_scripts')); ?> />
                    <label for="cwv_footer_scripts1">yes</label>
                </div>
                <p class="inlinehelp">Moving scripts to the footer of the page will enqueue them fow download slightly later.
                    This can improve the paint metrics (FCP and LCP).
                </p>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">Optimize Script events</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_optimize_script_events" id="cwv_optimize_script_events0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_optimize_script_events')); ?> />
                    <label for="cwv_optimize_script_events0">no</label>
                    <input name="cwv_optimize_script_events" id="cwv_optimize_script_events1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_optimize_script_events')); ?> />
                    <label for="cwv_optimize_script_events1">yes</label>
                </div>
                <p class="inlinehelp">Optimizing script events will fire 'script trigger events' only after all scripts have been loaded. Enable this setting if you get console errors after deferring all scripts.
                </p>
            </td>
        </tr>

    </table>

    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-scripts"></use>
        </svg>
        JavaScript priority finetuning
        <svg data-help=".lazyscriptshelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>
    <div class="cwvhelptext lazyscriptshelp">
        <p>This will override the 'defer' property and allows you to fine-tune the JavaScript priority.
            <span style="color:red">Be very careful</span> when using this feature because it might break site functionality!
        </p>

        To determine the right priority for a script you need to understand that not all scripts are equally important.
        <ul>
            <li>
                <b>Render Critical Scripts</b>.
                The page does not look the same and nowhere near complete without these scripts.
                These kind of scripts can only be added <b>‘render blocking’</b> to the page.
                This will hurt your page speed and UX.
                Therefore if these scripts are found on any page you might also want to consider rewriting this part of the site.
            </li>
            <li>
                <b>Critical Scripts</b>.
                These scripts are not needed for immediate render but should be loaded as soon as possible because
                they control things like the menu and basically the page does not work without it. 
                These scripts should be loaded <b>'async'</b> or <b>'deferred'</b>
            </li>
            <li>
                <b>Important Scripts (analytics for example)</b>.
                These Scripts are important and should be loaded early on but always after the Critical Scripts
                and preferably after the LCP.
                These scripts should als obe loaded <b>'async'</b> or <b>'deferred'</b>
            </li>
            <li>
                <b>Nice to have</b>.
                Some scripts (chat, facebook buttons) are nice to have but without them the page loads just fine 
                and most buisiness goals are met without these scripts. 
                These scripts should be loaded <b>'on browser idle'</b> or <b>'on browser interaction'</b> or with a custom trigger like '<b>on hover</b>' or '<b>on scroll into view</b>'</b>
            </li>


        </ul>

    </div>

    <div id="scriptrules">
    </div>

</div>