<?php

namespace WPCWV; 

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}
?>
<div class="cwv-tab-panel" id="tab-images" style="display: none;">


    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-images"></use>
        </svg>
        Images - LCP, lazy loading, missing height & width
        <svg data-help=".imageshelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>


    <div class="cwvhelptext imageshelp">
        <p>Images are a big part of the page weight. The images tab allows you to optimize your images for Core Web Vitals.</p>
        <p>The most important step to take is to idently the LCP element.
            The LCP element is the element that is the largest and usually the visually most important element on the page.
            <br />By identifying the LCP element we will make sure the LCP elent loads and renders as soon as possbile.
            This will reduce the LCP time and improve the user experience.
        </p>

        <p>Adding missing image height and width will reduce layout shift but might make images appear out of proportion. If images are out of proportion now try adding img{max-width:100%;height:auto;width:auto;} to your stylesheet.</p>
        <p>Lazy loading image will make the image load just before it is visible on scripp. 
            This will reduce the page weight and improve the page load time. This will improve the FID and CLS. 
            Try to enable Native lazy load and do not enable JavaScript lazy load</p>


    </div>


    <table class="form-table">
        <tr valign="top">
            <th scope="row">LCP element</th>
            <td>
                <textarea type="text" name="cwv_lcp_selector"><?php echo esc_attr(trim(cwv_options::get('cwv_lcp_selector'))); ?></textarea>
                <p class="inlinehelp">
                    <i>
                        Preloads the LCP element, sets hight fetchpriority, disables lazy loading for this element. <br />
                        Add class selectors for LCP elements, on selector per line: .image-large.
                        <br />
                        <b>Important</b> If you do not add your LCP CSS class selectors your LCP element will lazy load!</i>
                </p>
            </td>
        </tr>


        <tr valign="top">
            <th scope="row">Add image missing width and height</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_img_width_height" id="cwv_img_width_height0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_img_width_height')); ?> />
                    <label for="cwv_img_width_height0">no</label>
                    <input name="cwv_img_width_height" id="cwv_img_width_height1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_img_width_height')); ?> />
                    <label for="cwv_img_width_height1">yes</label>
                </div>
                <p class="inlinehelp">Adding missing image height and width will reduce layout shift but might make images appear out of proportion. Try adding img{max-width:100%;height:auto;width:auto;} to your stylesheet.</p>

            </td>
        </tr>


        <tr valign="top">
            <th scope="row">Enable native lazy load</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_lazy_load_images" id="cwv_lazy_load_images0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_lazy_load_images')); ?> />
                    <label for="cwv_lazy_load_images0">no</label>
                    <input name="cwv_lazy_load_images" id="cwv_lazy_load_images1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_lazy_load_images')); ?> />
                    <label for="cwv_lazy_load_images1">yes</label>
                </div>
                <p class="inlinehelp">Add native lazy loading to all images except the LCP element! </p>
            </td>
        </tr>



        <tr valign="top">
            <th scope="row">Lazy load inline background images</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_lazy_load_bg_images" id="cwv_lazy_load_bg_images0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_lazy_load_bg_images')); ?> />
                    <label for="cwv_lazy_load_bg_images0">no</label>
                    <input name="cwv_lazy_load_bg_images" id="cwv_lazy_load_bg_images1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_lazy_load_bg_images')); ?> />
                    <label for="cwv_lazy_load_bg_images1">yes</label>
                </div>
                <p class="inlinehelp">Delays background images just a tiny bit. This will priotize non-background images over background images and in some cases speed up the LCP. Do NOT enable when your LCP element is a background image!</p>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">Async render images</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_async_render_images" id="cwv_async_render_images0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_async_render_images')); ?> />
                    <label for="cwv_async_render_images0">no</label>
                    <input name="cwv_async_render_images" id="cwv_async_render_images1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_async_render_images')); ?> />
                    <label for="cwv_async_render_images1">yes</label>
                </div>
                <p class="inlinehelp">Prioritizes performance over image decoding except for any LCP image</p>
            </td>
        </tr>
       
    </table>


   

</div>