<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}
?>

<div class="cwv-tab-panel" id="tabs-help" style="display: none;">




    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-advisor"></use>
        </svg>
        Getting Started
        <svg data-help=".advisorhelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>

    <p>WP Core Web Vitals is a plugin that will help you to improve your Core Web Vitals scores.
        It will do this by optimizing your website and by adding some extra features to your website.</p>

    <h3>Step 1: Disable ALL caching plugins & PageSpeed optimisation plugins</h3>
    <p>WP Core WEb Vitals <b>needs a clean site</b> to begin with.
        Optimisations over optimisations is a bad idea and will result in unexpected results!
    </p>
    <p>
        Disable all plugins or features that:
    </p>
    <ol>
        <li>Generate Critcal CSS</li>
        <li>Combine Stylesheets</li>
        <li>Add extra lazy-loading behaviour</li>
        <li>Remove Google Fonts</li>
        <li>Defer, async, combine or otherwise optimize JavaScript</li>
    </ol>



    <h3>Step 2: Testing & Configuring!</h3>
    <p>Now that you have a clean site, you can start testing and configuring WP Core Web Vitals. We suggest that you first try out different setting on a stagin enviroment!</p>
    <p>WP Core Web Vitals comes with a pretty good preset configuration. You can start by testing your website with the default settings. </p>


    <h3>Step 3: Read the docs!</h3>
    <p>
        time to get real! I would love a click and go solution, but that's not how it works. 
        At some point you need to understand what you are doing and why you are doing it.
        Each feature has it's pro's and cons.
    </p>


    <h3>Step 4: Fix common issues:</h3>

    <ol>
        <li><b>Layout broke</b>: Cause: your HTML contains too many errors. Check: disable 'Minify HTML'. Solution: Fix your HTML</li>
        <li><b>Layout broke</b>: Cause: your CSS contains too many errors. Check: disable 'Optimize CSS filesize' & 'Compress CSS'. 
        Solution: Fix your stylesheets!</li>
        <li><b>Layout broke</b>: Cause: you are lazy loading your styles. Check: disable 'Optimize CSS filesize' & 'Compress CSS'. 
        Solution: do not lazy load styles!</li>
        <li><b>Layout broke</b>: Cause: you are blocking external visitors with a password. Check: visit your site incognito. 
        Solution: Allow our crawler</li>
        
        <li><b>Functionality broke</b>: Cause: there is an issue with deferred scripts. Check: disable 'Defer JavaScripts'. 
        Fine-tune the JavaScript priority!</li>
    </ol>



    <h3>Step 5: Enable caching</h3>
    <p>Enable Caching, clear the cache for good measure and test your website again.</p>

</div>