<?php

namespace WPCWV; 

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}
?>

<div class="cwv-tab-panel" id="tabs-font" style="display: none;">




    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-font"></use>
        </svg>
        Fonts
        <svg data-help=".fonthelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>

    <div class="cwvhelptext fonthelp">
        <p>Preloading web-fonts will make the available earlier on during the redering process. In most cases even before the rendering starts. This will eliminate Layout Shifts caused by web-fonts.</p>

    </div>



    <table class="form-table">
        <tr valign="top">
            <th scope="row">Improve font rendering</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_text_rendering" id="cwv_text_rendering0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_text_rendering')); ?> />
                    <label for="cwv_text_rendering0">no</label>
                    <input name="cwv_text_rendering" id="cwv_text_rendering1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_text_rendering')); ?> />
                    <label for="cwv_text_rendering1">yes</label>
                </div>
                <p class="inlinehelp">This will improve font rendering on your website. It will add the following CSS to your website: <code>text-rendering: optimizeSpeed;</code></p>
            </td>
        </tr>

        <tr valign="top">
            <th scope="row">Preload fonts</th>
            <td>
                <i>Please use the preload section</i>
            </td>
        </tr>


        <tr valign="top">
            <th scope="row">Remove google fonts & Adbode Fonts (typekit)</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_remove_google_fonts" id="cwv_remove_google_fonts0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_remove_google_fonts')); ?> />
                    <label for="cwv_remove_google_fonts0">no</label>
                    <input name="cwv_remove_google_fonts" id="cwv_remove_google_fonts1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_remove_google_fonts')); ?> />
                    <label for="cwv_remove_google_fonts1">yes</label>
                </div>
                <p class="inlinehelp">This will remove google fonts & typekit from the page. It is usually a lot faster to self host your fonts.
                    <br />
                    <b>Important!</b> after we have removed Google font you will need to upload your own font files to your server and add new font declarations to your stylesheet!
                    <br />
                    After we have removed Adobe fonts please check your licence agreement with Adobe. You might not be allowed to self host the fonts.
                </p>
            </td>
        </tr>


    </table>





    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-font"></use>
        </svg>
        Icons
        <svg data-help=".iconfonthelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>

    <div class="cwvhelptext iconfonthelp">
        <p>Sometimes you do not want icon fonts competing for resource during the start-up phase of pageload.
            This setting will ever so slightly delay the enqueueing of icon fonts by the browser.</p>

    </div>


    <table class="form-table">
        <tr valign="top">
            <th scope="row">Lazy load icon sets</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_lazy_load_icons" id="cwv_lazy_load_icons0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_lazy_load_icons')); ?> />
                    <label for="cwv_lazy_load_icons0">no</label>
                    <input name="cwv_lazy_load_icons" id="cwv_lazy_load_icons1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_lazy_load_icons')); ?> />
                    <label for="cwv_lazy_load_icons1">yes</label>
                </div>
                <p class="inlinehelp">This will ever so slightly change the icons sets (font awesome etc) timing to
                    allow more critical resources to be prioritized. Do not forget to reserve width for your icons that are rendering somehwat later:
                    <code>.fa {width:12px};</code>
                </p>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">Icon set classlist Selectors</th>
            <td>
                <input type="text" name="cwv_lazy_load_icons_classlist" value="<?php echo esc_attr(cwv_options::get('cwv_lazy_load_icons_classlist')); ?>" />
                <p class="inlinehelp">Tell us how to detect icon-sets by classlist. For example <code>.iconset,.menuicons</code></p>
            </td>
        </tr>
    </table>


</div>