<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}
?>
<div class="cwv-tab-panel" id="tabs-debug" style="display: none;">


    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-wrench"></use>
        </svg>
        Debug
        <svg data-help=".debugelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>

    <p>Sometimes you would like to know exactly what steps are taken to speed up the page. I have got you covered. Just add the url and see the debug data!</p>

    <div class="cwvhelptext debugelp">
        <p>Sometimes you would like to know exactly what steps are taken to speed up the page. I have got you covered. Just add the url and see the debug data!</p>

    </div>

    <table class="form-table">
        <tr valign="top" date-depends="cwv_footer_content_visibility">
            <th scope="row">Url to debug</th>
            <td><input id="cwv_debug_url" type="text" placeholder="https://www.example.com/test" name="cwv_debug_url" value="<?php echo esc_attr(WP_CWV_SITE_URL); ?>" />

            </td>
            <td><span id="cwv_debug_button" class=" button button-primary" data-id="6">Debug</span></td>
        </tr>

        <tr valign="top" date-depends="cwv_footer_content_visibility">
            <th scope="row">Debug results</th>
            <td colspan="2">
                <pre id="cwv_debug_data"> -- No results yet, you need to add and url and click debug first :-)</pre>
            </td>
        </tr>



    </table>

    <div data-depends="wp_cwv_page_cache">
        <h2 class="cwv-tab-heading">
            <svg class="icon">
                <use xlink:href="#icon-wrench"></use>
            </svg>
            Caching
            <svg data-help=".debugelp" class="cwv-help helpicon">
                <use xlink:href="#icon-question"></use>
            </svg>
        </h2>

        <p>Sometimes you need to tcaching to kick in after the plugins have loaded!</p>

        <table class="form-table">
            <tr valign="top">
                <th scope="row">Enable late cache</th>
                <td>
                    <div class="switch-field">
                        <input name="wp_cwv_late_cache" id="wp_cwv_late_cache0" type="radio" value="0" <?php checked('0', cwv_options::get('wp_cwv_late_cache')); ?> /><label for="wp_cwv_late_cache0">no</label>
                        <input name="wp_cwv_late_cache" id="wp_cwv_late_cache1" type="radio" value="1" <?php checked('1', cwv_options::get('wp_cwv_late_cache')); ?> /><label for="wp_cwv_late_cache1">yes</label>
                    </div>
                    <p>Usually you want to disable this setting. If you enable this setting caching will happen after the WordPress plugins have loaded.</p>
                </td>
            </tr>
        </table>
    </div>


    <div>
        <br />
        <h2 class="cwv-tab-heading">
            <svg class="icon">
                <use xlink:href="#icon-wrench"></use>
            </svg>
            Basic authentication
            <svg data-help=".debugelp" class="cwv-help helpicon">
                <use xlink:href="#icon-question"></use>
            </svg>
        </h2>

        <p>We can fetch styles, scripts and images from your server with basic authentication enabled</p>

        <table class="form-table">
            <tr valign="top">
                <th scope="row">Username</th>
                <td>
                    <input style="max-width:200px" type="text" name="cwv_auth_username" value="<?php echo esc_attr(cwv_options::get('cwv_auth_username')); ?>" />
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Password</th>
                <td>
                    <input style="max-width:200px" type="password" name="cwv_auth_password" value="<?php echo esc_attr(cwv_options::get('cwv_auth_password')); ?>" />
                </td>
            </tr>
        </table>
    </div>


    <div>
        <br />
        <h2 class="cwv-tab-heading">
            <svg class="icon">
                <use xlink:href="#icon-wrench"></use>
            </svg>
            Ignore List
            <svg data-help=".debugelp" class="cwv-help helpicon">
                <use xlink:href="#icon-question"></use>
            </svg>
        </h2>

        <p>We can ignore urls for optimisation based on part of the url. For example 'url-part|another-part' will ignore all urls with either 'url-part' or 'another-part' in the url</p>

        <table class="form-table">
            <tr valign="top">
                <th scope="row">Url parts</th>
                <td>
                    <input style="max-width:200px" type="text" name="wp_ignore_url_parts" value="<?php echo esc_attr(cwv_options::get('wp_ignore_url_parts')); ?>" />
                </td>
            </tr>
          
        </table>
    </div>

</div>