<?php


namespace WPCWV;

function formatCssClass($class)
{
    $all = explode(' ', trim($class));
    foreach ($all as $k => $c) {
        $delim = ($k == sizeof($all) - 1) ? '  ' : ' or ';
        echo '<b>.' . $c . '</b>' . $delim;
    }
}

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}
?>
<div class="cwv-tab-panel" id="tabs-dashboard">
    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-dashboard"></use>
        </svg>
        Dashboard
    </h2>
    <br />
    <div class="cwvcard pl tl intro">
        <div class="ig">
            <img src="https://www.corewebvitals.io/static/img/resize-90-90/s/arjen-sq.webp">
            <div>
                <p style="padding:0;margin:0;">

                    Hi there, I’m Arjen. I am a Core Web Vitals specialist & Web Performance Consultant from the Netherlands.
                    <br /><br />

                    I am dedicated to making the internet a faster place and that is why I have made WP Core Web Vitals <b>free for everyone!</b>
                    <br />
                    <br />

                    WP Core Web Vitals offers more flexibility in fixing Core Web Vitals issues and that is why WP Core Web Vitals currently outperforms all other pagespeed plugins (without dirty tricks or manipulating your lighthouse score!)
                    <br /><br />
                    Start by properly configuring this plugin. That will take some time and maybe a bit of reading up on the Core Web Vitals.
                    The end result will be worth it!
                </p>
            </div>
        </div>
    </div>


    <div class="g11">


        <div>
        <span></span>
            <h2 class="cwv-tab-heading">
                <svg class="icon">
                    <use xlink:href="#icon-pro"></use>
                </svg>
                WP Core Web Vitals news!
            </h2>
            <div class="cwvcard mt">

                <ul>
                    <li><b>Trimming the fat</b> Removed features that looked cool but in fact did little to help the Core Web Vitals</li>
                    <li><b>103 - Early hints</b> Early hint is supported through the Link header</li>
                    <li><b>Page prerender / prefetch</b> Dynamically preload or prefetch pages for faster TTFB</li>
                    <li><b>JavaScript loader</b> Lots of improvement for the JavaScript loader that will make your scripts load even faster without blocking the page!</li>
                    <li><b>Ultra fast caching</b> Faster caching (beta) and common tracking parameters are now ignored by the cache by default</li>
                   
                </ul>
            </div>

        </div>


        <div>
        <span></span>
    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-advisor"></use>
        </svg>
        Core Web Vitals advisor
    </h2>
    <div class="cwvcard mt">
        <p>
            Please take some time to properly configure WP core Web Vitals!
            Each site is different and requires a slightly different configuration for optimal results!
            Click-and-go might seem appealing but for the best results <a href="https://www.corewebvitals.io/wp-core-web-vitals/installation">read the documentation!</a>
        </p>

    </div>
    </div>
    </div>

    <!-- <div class="g g11" data-depends="wp_cwv_advisor">
        <?php if (false ==  cwv_options::get('cwv_lcp_selector')) { ?>
            <div class="cwvcard warning mt tl pl">
                <h2><span>&#xbb;</span> Missing Critical configuration!</h2>
                <p>Identify the 'LCP' element. This is critical for any fast webpage. Navigate to the on 'Images' tab and update the 'LCP element' option.</p>
                <a href="https://dev.corewebvitals.io/wp-core-web-vitals/images#lcpel" target="_blank" class="button">Read the docs</a>
            </div>
        <?php } ?>


     
    </div>


    <div class="cwvcard mt">
        <h2>Fix the Time To First Byte</h2>
        <p>
            You rTime to First Byte is a bit high (p75 = 911ms). Please enable Caching, Consider enbling more caching and check out these tips
        </p>
    </div> -->











    <h2 class="cwv-tab-heading"><svg class="icon">
            <use xlink:href="#icon-refresh"></use>
        </svg>Cache</h2>
    <p>* WP Core Web Vitals will clear it's cache automatically. On site-wide changes clear the cache manually.</p>
    <a id="clearhtmlcache" class="button button-primary" href="#">Clear HTML Cache</a>
</div>