<?php

namespace WPCWV; 

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}
?>
<div class="cwv-tab-panel" id="tab-css" style="display: none;">
   
    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-css3"></use>
        </svg>
        Styles - Compression and filesize
        <svg data-help=".csscompressionhelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>


    <div class="cwvhelptext csscompressionhelp">
        <p>Optimizing the CSS fielsize will combine your CSS files into multiple-same sized CSS files.
            This will optmize the CSS load time and reduce render delay caused by CSS files.
            This will work fine for most sites but can break your CSS if you have errors in your CSS. Be carefull with this feature!
        </p>
        <p>Compress CSS will minimize your CSS. This will work fine for most sites but can break your CSS if you have errors in your CSS. Be carefull with this feature.</p>



    </div>


    <table class="form-table">

        <tr valign="top">
            <th scope="row">Optimize CSS filesize</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_combine_css" id="cwv_combine_css0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_combine_css')); ?> />
                    <label for="cwv_combine_css0">no</label>
                    <input name="cwv_combine_css" id="cwv_combine_css2" type="radio" value="2" <?php checked('2', cwv_options::get('cwv_combine_css')); ?> />
                    <label for="cwv_combine_css2">single file</label>
                    <input name="cwv_combine_css" id="cwv_combine_css3" type="radio" value="3" <?php checked('3', cwv_options::get('cwv_combine_css')); ?> />
                    <label for="cwv_combine_css3">smart</label>
                    <input name="cwv_combine_css" id="cwv_combine_css1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_combine_css')); ?> />
                    <label for="cwv_combine_css1">optimized number</label>
                </div>
                <p class="inlinehelp">This setting will combine your CSS files into multiple-same sized CSS files.
                    This will optmize the CSS load time and reduce render delay caused by CSS files.</p>
            </td>
        </tr>
        <tr valign="top" data-depends="cwv_combine_css">
            <th scope="row">Optimize inline CSS</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_combine_inline_css" id="cwv_combine_inline_css0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_combine_inline_css')); ?> />
                    <label for="cwv_combine_inline_css0">no</label>
                    <input name="cwv_combine_inline_css" id="cwv_combine_inline_css1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_combine_inline_css')); ?> />
                    <label for="cwv_combine_inline_css1">yes</label>
                </div>
                <p class="inlinehelp">This will move your inline styles to external stylesheets and make those styles cache-able. 
                    However this can create many external stylesheets and should only be used if inline styles are consistent! Be carefull with this feature</p>
            </td>
        </tr>
        <tr valign="top" data-depends="cwv_combine_css">
            <th scope="row">Compress CSS</th>
            <td>
                <div class="switch-field">
                    <input name="compress_css" id="compress_css0" type="radio" value="0" <?php checked('0', cwv_options::get('compress_css')); ?> />
                    <label for="compress_css0">no</label>
                    <input name="compress_css" id="compress_css1" type="radio" value="1" <?php checked('1', cwv_options::get('compress_css')); ?> />
                    <label for="compress_css1">yes</label>
                </div>
                <p class="inlinehelp">Compressing your CSS will minimze the CSS filesize but can break your CSS. Be carefull with this feature</p>
            </td>
        </tr>




    </table>
    <br />
    <br />
    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-css3"></use>
        </svg>
        Styles - Advanced options
        <svg data-help=".advancedstyleshelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>
    <div class="cwvhelptext advancedstyleshelp">
        <p>This is a list of all generated Critical CSS files. We will generate a critical CSS file of each page type, template and post type combination.</p>
    </div>
    <table class="form-table">


        <tr valign="top">
            <th scope="row">Ignore optimization for (regex)</th>
            <td>
                <input type="text" name="cwv_css_lower_regex" value="<?php echo esc_attr(cwv_options::get('cwv_css_lower_regex')); ?>" />
                <p class="inlinehelp">If you need to ignore a CSS file and just keep it the way it is you can add a regex here.
                    This will prevent the CSS file from being optimized. To match main.min.css and extra.min.css type <i>"main|extra"</i></p>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">Add extra CSS</th>
            <td>
                <textarea type="text" name="cwv_extra_css"><?php echo esc_attr(stripslashes(cwv_options::get('cwv_extra_css'))); ?></textarea>
                <p class="inlinehelp">Use this to correct tiny Critical CSS mistakes. This CSS will be added to the Inline CSS.</p>
            </td>
        </tr>
    </table>
</div>