<?php

namespace WPCWV;

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}
?>
<div class="cwv-tab-panel" id="tabs-cdn" style="display: none;">
    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-pro"></use>
        </svg>
        CDN
        <svg data-help=".criticalcssoptshelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>


    <div class="cwvhelptext criticalcssoptshelp">
        <p>This will let you sync CDN cache with the plugins cache</p>
    </div>


    
    <h2>We have detected a CDN!</h2>
    <p>
        We have detected that you are using CloudFlare. If you want to use the CloudFlare CDN cache purge feature, you need to create an API token.
        This token will be used to purge the cache when the plugin purges the cache.

    <p>
        To Create an API token log into cloudFlare and go to
        <a href="https://dash.cloudflare.com/profile/api-tokens" target="_blank">https://dash.cloudflare.com/profile/api-tokens</a>.
        and follow these steps!

    <ol>




        <li>Click on "Create Token" and select "Create Custom Token". Dont forget to give that token a name.</li>
        <li>
            In the permission section select "Zone" and "Cache Purge" and "Purge".</li>
        <li>
            In the zone resources section select "Include" and "Specific Zone" and select your domain.</li>
        <li>

            Click on continue to summary and then on "Create Token".</li>
        <li>

            Copy the token and paste it in the field below.</li>
        <li>

            Then go to your CloudFlare dashboard and copy the zone ID and paste it in the field below.</li>
    </ol>


    </p>
    <table class="form-table">
        <tr valign="top">
            <th scope="row">CloudFlare API Token</th>
            <td>
                <input type="text" name="cwv_cf_token" value="<?php echo esc_attr(cwv_options::get('cwv_cf_token')); ?>" />
                <p class="inlinehelp">Your CloudFlare API token</p>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">CloudFlare Zone Id</th>
            <td>
                <input type="text" name="cwv_cf_zone" value="<?php echo esc_attr(cwv_options::get('cwv_cf_zone')); ?>" />

                <p class="inlinehelp">Your CloudFlare zone ID.</p>
            </td>
        </tr>
    </table>



</div>