<?php

namespace WPCWV; 

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}
?>

<div class="cwv-tab-panel" id="tabs-cache" style="display: none;">


    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-cache"></use>
        </svg>
        Page caching
        <svg data-help=".cachehelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>


    <div class="cwvhelptext cachehelp">
        <p>We <b>strongly recomment</b> to enable page caching since it works very well with our other features like CSS optimization, image optimization and lazy loading.</p>
        <p>Page Caching speeds up the Time To First Byte and makes the page load as fast as possbile.
            This also improves the Largest Contentful Paint & the First Contentful Paint.
        </p>
        <p>WP Core Web Vitals will bypass the cache for logged in users and on well known pages (checkout, cart etc).
            If you need to exclude more pages you can add them in the bypass cache field.</p>
        <p>By default we do not cache pages with url parameters (/some-page?this=parameter). This can result in a lot of cache files with a low hit-rate.
            If you need to cache pages with url parameters check this option.</p>





    </div>

    <table class="form-table" width="100%">
        <tr valign="top">
            <th scope="row">Enable full page caching</th>
            <td>
                <div class="switch-field">
                    <input name="wp_cwv_page_cache" id="wp_cwv_page_cache0" type="radio" value="0" <?php checked('0', cwv_options::get('wp_cwv_page_cache')); ?> /><label for="wp_cwv_page_cache0">no</label>
                    <input name="wp_cwv_page_cache" id="wp_cwv_page_cache1" type="radio" value="1" <?php checked('1', cwv_options::get('wp_cwv_page_cache')); ?> /><label for="wp_cwv_page_cache1">yes</label>
                </div>
                <p class="inlinehelp">Caching speeds up the TTFB. Make sure to have at least one caching mechanism available</p>
            </td>
        </tr>

        <tr valign="top" data-depends="wp_cwv_page_cache">
            <th scope="row">Cache Time To Live</th>
            <td>
                <select name="wp_cwv_cache_ttl_hours">
                    <option value="1" <?php selected('1', cwv_options::get('wp_cwv_cache_ttl_hours')); ?>>1 hour</option>
                    <option value="4" <?php selected('4', cwv_options::get('wp_cwv_cache_ttl_hours')); ?>>4 hours</option>
                    <option value="8" <?php selected('8', cwv_options::get('wp_cwv_cache_ttl_hours')); ?>>8 hours</option>
                    <option value="12" <?php selected('12', cwv_options::get('wp_cwv_cache_ttl_hours')); ?>>12 hours</option>
                    <option value="24" <?php selected('24', cwv_options::get('wp_cwv_cache_ttl_hours')); ?>>1 day</option>
                    <option value="48" <?php selected('48', cwv_options::get('wp_cwv_cache_ttl_hours')); ?>>2 days</option>
                    <option value="96" <?php selected('96', cwv_options::get('wp_cwv_cache_ttl_hours')); ?>>4 days</option>
                    <option value="168" <?php selected('168', cwv_options::get('wp_cwv_cache_ttl_hours')); ?>>1 week</option>
                    <option value="336" <?php selected('336', cwv_options::get('wp_cwv_cache_ttl_hours')); ?>>2 weeks</option>
                    <option value="744" <?php selected('744', cwv_options::get('wp_cwv_cache_ttl_hours')); ?>>1 month</option>
                    <option value="4464" <?php selected('4464', cwv_options::get('wp_cwv_cache_ttl_hours')); ?>>6 months</option>
                </select>
                <p class="inlinehelp">Delete cache files after this time. </p>
            </td>
        </tr>


        <tr valign="top" data-depends="wp_cwv_page_cache">
            <th scope="row">Ignore query strings</th>
            <td>
                <input type="text" name="wp_cwv_cache_ignore_qs" value="<?php echo esc_attr(cwv_options::get('wp_cwv_cache_ignore_qs')); ?>" />
                <p class="inlinehelp">
                Comma separated list of url parameters to ignore when checking for cache files. For example <i>"trackid,clickid"</i> ignores both url parameters in www.example.com/?trackid=1&clickid=2</p>
            </td>
        </tr>

        <tr valign="top" data-depends="wp_cwv_page_cache">
            <th scope="row">Bypass cache</th>
            <td>
                <textarea type="text" name="cwv_bypage_cache"><?php echo esc_attr(cwv_options::get('cwv_bypage_cache')); ?></textarea>
                <p class="inlinehelp">
                    Bypass cache if page matches a rule. One rule per line. 
                    <br /> Be specific: <b>feed</b> matches www.example.com/<b>feed</b> and also example.com/how-to-<b>feed</b>-your-pet
                </p>
            </td>
        </tr>

        <tr valign="top" data-depends="wp_cwv_page_cache">
            <th scope="row">Clear pages on new post</th>
            <td>
                <textarea type="text" name="wp_cwv_pages_to_clear" placeholder="https://www.example.com/blog/"><?php echo esc_attr(cwv_options::get('wp_cwv_pages_to_clear')); ?></textarea>
                <p class="inlinehelp">Clear these pages when a new post has been added or posts have changed. For example post listing pages. One rule per line. </p>
            </td>
        </tr>



        <tr valign="top" data-depends="wp_cwv_page_cache">
            <th scope="row">Cache pages with url parameters</th>
            <td>
                <div class="switch-field">
                    <input name="wp_cwv_page_cache_urlparam" id="wp_cwv_page_cache_urlparam0" type="radio" value="0" <?php checked('0', cwv_options::get('wp_cwv_page_cache_urlparam')); ?> /><label for="wp_cwv_page_cache_urlparam0">no</label>
                    <input name="wp_cwv_page_cache_urlparam" id="wp_cwv_page_cache_urlparam1" type="radio" value="1" <?php checked('1', cwv_options::get('wp_cwv_page_cache_urlparam')); ?> /><label for="wp_cwv_page_cache_urlparam1">yes</label>
                </div>
                <p>Usually you want to disable this setting. If you enable this setting you will cache pages with url parameters. This might result in a lot of cached pages. If you enable this setting you should also enable the 'Enable full page caching' setting.</p>
            </td>
        </tr>
     

        
     


    </table>
</div>