<?php

namespace WPCWV;

use WP_Rocket\Engine\Cache\AdvancedCache;

if (!defined('ABSPATH')) {
    die('Let\'s not do this');
}
?>

<div class="cwv-tab-panel" id="tabs-beta" style="display: none;">

    <h2 class="cwv-tab-heading">
        <svg class="icon">
            <use xlink:href="#icon-beta"></use>
        </svg>
        Beta Features
        <svg data-help=".betahelp" class="cwv-help helpicon">
            <use xlink:href="#icon-question"></use>
        </svg>
    </h2>

    <div class="cwvhelptext betahelp">
        <p>Beta features, use at your own risk!!.</p>

    </div>

    <table class="form-table">
        <tr valign="top">
            <th scope="row">Show beta features</th>
            <td>
                <div class="switch-field">
                    <input name="cwv_show_beta_features" id="cwv_show_beta_features0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_show_beta_features')); ?> />
                    <label for="cwv_show_beta_features0">no</label>
                    <input name="cwv_show_beta_features" id="cwv_show_beta_features1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_show_beta_features')); ?> />
                    <label for="cwv_show_beta_features1">yes</label>
                </div>
                <p class="inlinehelp">Show beta features? Use at your own risk! Current beta features are 'Fast Cache'</p>
            </td>
        </tr>
    </table>

    <div data-depends="cwv_show_beta_features">
        <div></div>
        <h2 class="cwv-tab-heading">
            <svg class="icon">
                <use xlink:href="#icon-cache"></use>
            </svg>
            Activate ultra fast cache
        </h2>
    </div>

    <div data-depends="cwv_show_beta_features">
        <table class="form-table">
            <tr valign="top">
                <th scope="row">Enable direct WP Adavanced Cache</th>
                <td>
                    <div class="switch-field">
                        <input name="cwv_use_advanced_cache" id="cwv_use_advanced_cache0" type="radio" value="0" <?php checked('0', cwv_options::get('cwv_use_advanced_cache')); ?> />
                        <label for="cwv_use_advanced_cache0">no</label>
                        <input name="cwv_use_advanced_cache" id="cwv_use_advanced_cache1" type="radio" value="1" <?php checked('1', cwv_options::get('cwv_use_advanced_cache')); ?> />
                        <label for="cwv_use_advanced_cache1">yes</label>
                    </div>
                    <p class="inlinehelp">WP advanced Caches uses a much faster caching mechanism but requires simple manual setup. </p>
                </td>
            </tr>
        </table>

        
        <?php if (false == defined('WP_CACHE') &&  false == FileSystem::file_is_writable('wp-config')) { ?>
            <div data-depends="cwv_use_advanced_cache">
                
                <p><b>WP-content not writable</b> We cannot automatically setup advanced cache for you because <code>wp-config.php</code> is not writable. Please make sure the file is writable or manually add '<code>define( 'WP_CACHE', true );</code>' to this file.</p>
            </div>
        <?php } ?>

        <?php if (false == FileSystem::file_is_writable('advanced-cache')) { ?>
            <div data-depends="cwv_use_advanced_cache">

                
                <p><b>Advanced-cache.php not writable:</b> We cannot automatically setup advanced cache for you because <code>wp-content/advanced-cache.php</code> is not writable.
                    Please make sure the file is writable or manually overwrite the file with this code:<br />
                <pre><?php echo htmlentities(cwv_advanced_cache::$advancedCacheCode); ?></pre>
                </p>
            </div>
        <?php } ?>


    </div>

</div>